/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;

public class DescribeEndpointsPublisher
implements SdkPublisher<DescribeEndpointsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEndpointsPublisher(DatabaseMigrationAsyncClient client, DescribeEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEndpointsPublisher(DatabaseMigrationAsyncClient client, DescribeEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeEndpointsPublisher resume(DescribeEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEndpointsPublisher(this.client, (DescribeEndpointsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEndpointsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeEndpointsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeEndpointsResponse> {
        private DescribeEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEndpointsResponse> nextPage(DescribeEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointsPublisher.this.client.describeEndpoints(DescribeEndpointsPublisher.this.firstRequest);
            }
            return DescribeEndpointsPublisher.this.client.describeEndpoints((DescribeEndpointsRequest)((Object)DescribeEndpointsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

