/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Certificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Certificate> {
    private static final SdkField<String> CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateIdentifier").getter(Certificate.getter(Certificate::certificateIdentifier)).setter(Certificate.setter(Builder::certificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIdentifier").build()}).build();
    private static final SdkField<Instant> CERTIFICATE_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CertificateCreationDate").getter(Certificate.getter(Certificate::certificateCreationDate)).setter(Certificate.setter(Builder::certificateCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateCreationDate").build()}).build();
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificatePem").getter(Certificate.getter(Certificate::certificatePem)).setter(Certificate.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatePem").build()}).build();
    private static final SdkField<SdkBytes> CERTIFICATE_WALLET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CertificateWallet").getter(Certificate.getter(Certificate::certificateWallet)).setter(Certificate.setter(Builder::certificateWallet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateWallet").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(Certificate.getter(Certificate::certificateArn)).setter(Certificate.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateOwner").getter(Certificate.getter(Certificate::certificateOwner)).setter(Certificate.setter(Builder::certificateOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateOwner").build()}).build();
    private static final SdkField<Instant> VALID_FROM_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidFromDate").getter(Certificate.getter(Certificate::validFromDate)).setter(Certificate.setter(Builder::validFromDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFromDate").build()}).build();
    private static final SdkField<Instant> VALID_TO_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidToDate").getter(Certificate.getter(Certificate::validToDate)).setter(Certificate.setter(Builder::validToDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidToDate").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlgorithm").getter(Certificate.getter(Certificate::signingAlgorithm)).setter(Certificate.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final SdkField<Integer> KEY_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("KeyLength").getter(Certificate.getter(Certificate::keyLength)).setter(Certificate.setter(Builder::keyLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_IDENTIFIER_FIELD, CERTIFICATE_CREATION_DATE_FIELD, CERTIFICATE_PEM_FIELD, CERTIFICATE_WALLET_FIELD, CERTIFICATE_ARN_FIELD, CERTIFICATE_OWNER_FIELD, VALID_FROM_DATE_FIELD, VALID_TO_DATE_FIELD, SIGNING_ALGORITHM_FIELD, KEY_LENGTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Certificate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateIdentifier;
    private final Instant certificateCreationDate;
    private final String certificatePem;
    private final SdkBytes certificateWallet;
    private final String certificateArn;
    private final String certificateOwner;
    private final Instant validFromDate;
    private final Instant validToDate;
    private final String signingAlgorithm;
    private final Integer keyLength;

    private Certificate(BuilderImpl builder) {
        this.certificateIdentifier = builder.certificateIdentifier;
        this.certificateCreationDate = builder.certificateCreationDate;
        this.certificatePem = builder.certificatePem;
        this.certificateWallet = builder.certificateWallet;
        this.certificateArn = builder.certificateArn;
        this.certificateOwner = builder.certificateOwner;
        this.validFromDate = builder.validFromDate;
        this.validToDate = builder.validToDate;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.keyLength = builder.keyLength;
    }

    public final String certificateIdentifier() {
        return this.certificateIdentifier;
    }

    public final Instant certificateCreationDate() {
        return this.certificateCreationDate;
    }

    public final String certificatePem() {
        return this.certificatePem;
    }

    public final SdkBytes certificateWallet() {
        return this.certificateWallet;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String certificateOwner() {
        return this.certificateOwner;
    }

    public final Instant validFromDate() {
        return this.validFromDate;
    }

    public final Instant validToDate() {
        return this.validToDate;
    }

    public final String signingAlgorithm() {
        return this.signingAlgorithm;
    }

    public final Integer keyLength() {
        return this.keyLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateWallet());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFromDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.validToDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)obj;
        return Objects.equals(this.certificateIdentifier(), other.certificateIdentifier()) && Objects.equals(this.certificateCreationDate(), other.certificateCreationDate()) && Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.certificateWallet(), other.certificateWallet()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateOwner(), other.certificateOwner()) && Objects.equals(this.validFromDate(), other.validFromDate()) && Objects.equals(this.validToDate(), other.validToDate()) && Objects.equals(this.signingAlgorithm(), other.signingAlgorithm()) && Objects.equals(this.keyLength(), other.keyLength());
    }

    public final String toString() {
        return ToString.builder((String)"Certificate").add("CertificateIdentifier", (Object)this.certificateIdentifier()).add("CertificateCreationDate", (Object)this.certificateCreationDate()).add("CertificatePem", (Object)this.certificatePem()).add("CertificateWallet", (Object)this.certificateWallet()).add("CertificateArn", (Object)this.certificateArn()).add("CertificateOwner", (Object)this.certificateOwner()).add("ValidFromDate", (Object)this.validFromDate()).add("ValidToDate", (Object)this.validToDate()).add("SigningAlgorithm", (Object)this.signingAlgorithm()).add("KeyLength", (Object)this.keyLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateIdentifier()));
            }
            case "CertificateCreationDate": {
                return Optional.ofNullable(clazz.cast(this.certificateCreationDate()));
            }
            case "CertificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "CertificateWallet": {
                return Optional.ofNullable(clazz.cast(this.certificateWallet()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "CertificateOwner": {
                return Optional.ofNullable(clazz.cast(this.certificateOwner()));
            }
            case "ValidFromDate": {
                return Optional.ofNullable(clazz.cast(this.validFromDate()));
            }
            case "ValidToDate": {
                return Optional.ofNullable(clazz.cast(this.validToDate()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithm()));
            }
            case "KeyLength": {
                return Optional.ofNullable(clazz.cast(this.keyLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CertificateIdentifier", CERTIFICATE_IDENTIFIER_FIELD);
        map.put("CertificateCreationDate", CERTIFICATE_CREATION_DATE_FIELD);
        map.put("CertificatePem", CERTIFICATE_PEM_FIELD);
        map.put("CertificateWallet", CERTIFICATE_WALLET_FIELD);
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("CertificateOwner", CERTIFICATE_OWNER_FIELD);
        map.put("ValidFromDate", VALID_FROM_DATE_FIELD);
        map.put("ValidToDate", VALID_TO_DATE_FIELD);
        map.put("SigningAlgorithm", SIGNING_ALGORITHM_FIELD);
        map.put("KeyLength", KEY_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateIdentifier;
        private Instant certificateCreationDate;
        private String certificatePem;
        private SdkBytes certificateWallet;
        private String certificateArn;
        private String certificateOwner;
        private Instant validFromDate;
        private Instant validToDate;
        private String signingAlgorithm;
        private Integer keyLength;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            this.certificateIdentifier(model.certificateIdentifier);
            this.certificateCreationDate(model.certificateCreationDate);
            this.certificatePem(model.certificatePem);
            this.certificateWallet(model.certificateWallet);
            this.certificateArn(model.certificateArn);
            this.certificateOwner(model.certificateOwner);
            this.validFromDate(model.validFromDate);
            this.validToDate(model.validToDate);
            this.signingAlgorithm(model.signingAlgorithm);
            this.keyLength(model.keyLength);
        }

        public final String getCertificateIdentifier() {
            return this.certificateIdentifier;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        @Override
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final Instant getCertificateCreationDate() {
            return this.certificateCreationDate;
        }

        public final void setCertificateCreationDate(Instant certificateCreationDate) {
            this.certificateCreationDate = certificateCreationDate;
        }

        @Override
        public final Builder certificateCreationDate(Instant certificateCreationDate) {
            this.certificateCreationDate = certificateCreationDate;
            return this;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final ByteBuffer getCertificateWallet() {
            return this.certificateWallet == null ? null : this.certificateWallet.asByteBuffer();
        }

        public final void setCertificateWallet(ByteBuffer certificateWallet) {
            this.certificateWallet(certificateWallet == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)certificateWallet));
        }

        @Override
        public final Builder certificateWallet(SdkBytes certificateWallet) {
            this.certificateWallet = certificateWallet;
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateOwner() {
            return this.certificateOwner;
        }

        public final void setCertificateOwner(String certificateOwner) {
            this.certificateOwner = certificateOwner;
        }

        @Override
        public final Builder certificateOwner(String certificateOwner) {
            this.certificateOwner = certificateOwner;
            return this;
        }

        public final Instant getValidFromDate() {
            return this.validFromDate;
        }

        public final void setValidFromDate(Instant validFromDate) {
            this.validFromDate = validFromDate;
        }

        @Override
        public final Builder validFromDate(Instant validFromDate) {
            this.validFromDate = validFromDate;
            return this;
        }

        public final Instant getValidToDate() {
            return this.validToDate;
        }

        public final void setValidToDate(Instant validToDate) {
            this.validToDate = validToDate;
        }

        @Override
        public final Builder validToDate(Instant validToDate) {
            this.validToDate = validToDate;
            return this;
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public final Integer getKeyLength() {
            return this.keyLength;
        }

        public final void setKeyLength(Integer keyLength) {
            this.keyLength = keyLength;
        }

        @Override
        public final Builder keyLength(Integer keyLength) {
            this.keyLength = keyLength;
            return this;
        }

        public Certificate build() {
            return new Certificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Certificate> {
        public Builder certificateIdentifier(String var1);

        public Builder certificateCreationDate(Instant var1);

        public Builder certificatePem(String var1);

        public Builder certificateWallet(SdkBytes var1);

        public Builder certificateArn(String var1);

        public Builder certificateOwner(String var1);

        public Builder validFromDate(Instant var1);

        public Builder validToDate(Instant var1);

        public Builder signingAlgorithm(String var1);

        public Builder keyLength(Integer var1);
    }
}

