/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse;

public class DescribeEngineVersionsIterable
implements SdkIterable<DescribeEngineVersionsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEngineVersionsIterable(DatabaseMigrationClient client, DescribeEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeEngineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeEngineVersionsResponseFetcher
    implements SyncPageFetcher<DescribeEngineVersionsResponse> {
        private DescribeEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEngineVersionsResponse nextPage(DescribeEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEngineVersionsIterable.this.client.describeEngineVersions(DescribeEngineVersionsIterable.this.firstRequest);
            }
            return DescribeEngineVersionsIterable.this.client.describeEngineVersions((DescribeEngineVersionsRequest)((Object)DescribeEngineVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

