/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.EndpointSettingEnumValuesCopier;
import software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointSetting> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EndpointSetting.getter(EndpointSetting::name)).setter(EndpointSetting.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(EndpointSetting.getter(EndpointSetting::typeAsString)).setter(EndpointSetting.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> ENUM_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnumValues").getter(EndpointSetting.getter(EndpointSetting::enumValues)).setter(EndpointSetting.setter(Builder::enumValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnumValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SENSITIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Sensitive").getter(EndpointSetting.getter(EndpointSetting::sensitive)).setter(EndpointSetting.setter(Builder::sensitive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sensitive").build()}).build();
    private static final SdkField<String> UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Units").getter(EndpointSetting.getter(EndpointSetting::units)).setter(EndpointSetting.setter(Builder::units)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Units").build()}).build();
    private static final SdkField<String> APPLICABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Applicability").getter(EndpointSetting.getter(EndpointSetting::applicability)).setter(EndpointSetting.setter(Builder::applicability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applicability").build()}).build();
    private static final SdkField<Integer> INT_VALUE_MIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IntValueMin").getter(EndpointSetting.getter(EndpointSetting::intValueMin)).setter(EndpointSetting.setter(Builder::intValueMin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntValueMin").build()}).build();
    private static final SdkField<Integer> INT_VALUE_MAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IntValueMax").getter(EndpointSetting.getter(EndpointSetting::intValueMax)).setter(EndpointSetting.setter(Builder::intValueMax)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntValueMax").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(EndpointSetting.getter(EndpointSetting::defaultValue)).setter(EndpointSetting.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, ENUM_VALUES_FIELD, SENSITIVE_FIELD, UNITS_FIELD, APPLICABILITY_FIELD, INT_VALUE_MIN_FIELD, INT_VALUE_MAX_FIELD, DEFAULT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("EnumValues", ENUM_VALUES_FIELD);
            this.put("Sensitive", SENSITIVE_FIELD);
            this.put("Units", UNITS_FIELD);
            this.put("Applicability", APPLICABILITY_FIELD);
            this.put("IntValueMin", INT_VALUE_MIN_FIELD);
            this.put("IntValueMax", INT_VALUE_MAX_FIELD);
            this.put("DefaultValue", DEFAULT_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final List<String> enumValues;
    private final Boolean sensitive;
    private final String units;
    private final String applicability;
    private final Integer intValueMin;
    private final Integer intValueMax;
    private final String defaultValue;

    private EndpointSetting(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.enumValues = builder.enumValues;
        this.sensitive = builder.sensitive;
        this.units = builder.units;
        this.applicability = builder.applicability;
        this.intValueMin = builder.intValueMin;
        this.intValueMax = builder.intValueMax;
        this.defaultValue = builder.defaultValue;
    }

    public final String name() {
        return this.name;
    }

    public final EndpointSettingTypeValue type() {
        return EndpointSettingTypeValue.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasEnumValues() {
        return this.enumValues != null && !(this.enumValues instanceof SdkAutoConstructList);
    }

    public final List<String> enumValues() {
        return this.enumValues;
    }

    public final Boolean sensitive() {
        return this.sensitive;
    }

    public final String units() {
        return this.units;
    }

    public final String applicability() {
        return this.applicability;
    }

    public final Integer intValueMin() {
        return this.intValueMin;
    }

    public final Integer intValueMax() {
        return this.intValueMax;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnumValues() ? this.enumValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitive());
        hashCode = 31 * hashCode + Objects.hashCode(this.units());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicability());
        hashCode = 31 * hashCode + Objects.hashCode(this.intValueMin());
        hashCode = 31 * hashCode + Objects.hashCode(this.intValueMax());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointSetting)) {
            return false;
        }
        EndpointSetting other = (EndpointSetting)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasEnumValues() == other.hasEnumValues() && Objects.equals(this.enumValues(), other.enumValues()) && Objects.equals(this.sensitive(), other.sensitive()) && Objects.equals(this.units(), other.units()) && Objects.equals(this.applicability(), other.applicability()) && Objects.equals(this.intValueMin(), other.intValueMin()) && Objects.equals(this.intValueMax(), other.intValueMax()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointSetting").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("EnumValues", this.hasEnumValues() ? this.enumValues() : null).add("Sensitive", (Object)this.sensitive()).add("Units", (Object)this.units()).add("Applicability", (Object)this.applicability()).add("IntValueMin", (Object)this.intValueMin()).add("IntValueMax", (Object)this.intValueMax()).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "EnumValues": {
                return Optional.ofNullable(clazz.cast(this.enumValues()));
            }
            case "Sensitive": {
                return Optional.ofNullable(clazz.cast(this.sensitive()));
            }
            case "Units": {
                return Optional.ofNullable(clazz.cast(this.units()));
            }
            case "Applicability": {
                return Optional.ofNullable(clazz.cast(this.applicability()));
            }
            case "IntValueMin": {
                return Optional.ofNullable(clazz.cast(this.intValueMin()));
            }
            case "IntValueMax": {
                return Optional.ofNullable(clazz.cast(this.intValueMax()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EndpointSetting, T> g) {
        return obj -> g.apply((EndpointSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private List<String> enumValues = DefaultSdkAutoConstructList.getInstance();
        private Boolean sensitive;
        private String units;
        private String applicability;
        private Integer intValueMin;
        private Integer intValueMax;
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointSetting model) {
            this.name(model.name);
            this.type(model.type);
            this.enumValues(model.enumValues);
            this.sensitive(model.sensitive);
            this.units(model.units);
            this.applicability(model.applicability);
            this.intValueMin(model.intValueMin);
            this.intValueMax(model.intValueMax);
            this.defaultValue(model.defaultValue);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EndpointSettingTypeValue type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getEnumValues() {
            if (this.enumValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enumValues;
        }

        public final void setEnumValues(Collection<String> enumValues) {
            this.enumValues = EndpointSettingEnumValuesCopier.copy(enumValues);
        }

        @Override
        public final Builder enumValues(Collection<String> enumValues) {
            this.enumValues = EndpointSettingEnumValuesCopier.copy(enumValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumValues(String ... enumValues) {
            this.enumValues(Arrays.asList(enumValues));
            return this;
        }

        public final Boolean getSensitive() {
            return this.sensitive;
        }

        public final void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }

        @Override
        public final Builder sensitive(Boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public final String getUnits() {
            return this.units;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        @Override
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        public final String getApplicability() {
            return this.applicability;
        }

        public final void setApplicability(String applicability) {
            this.applicability = applicability;
        }

        @Override
        public final Builder applicability(String applicability) {
            this.applicability = applicability;
            return this;
        }

        public final Integer getIntValueMin() {
            return this.intValueMin;
        }

        public final void setIntValueMin(Integer intValueMin) {
            this.intValueMin = intValueMin;
        }

        @Override
        public final Builder intValueMin(Integer intValueMin) {
            this.intValueMin = intValueMin;
            return this;
        }

        public final Integer getIntValueMax() {
            return this.intValueMax;
        }

        public final void setIntValueMax(Integer intValueMax) {
            this.intValueMax = intValueMax;
        }

        @Override
        public final Builder intValueMax(Integer intValueMax) {
            this.intValueMax = intValueMax;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public EndpointSetting build() {
            return new EndpointSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointSetting> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(EndpointSettingTypeValue var1);

        public Builder enumValues(Collection<String> var1);

        public Builder enumValues(String ... var1);

        public Builder sensitive(Boolean var1);

        public Builder units(String var1);

        public Builder applicability(String var1);

        public Builder intValueMin(Integer var1);

        public Builder intValueMax(Integer var1);

        public Builder defaultValue(String var1);
    }
}

