/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse;

public class DescribeReplicationTaskAssessmentRunsPublisher
implements SdkPublisher<DescribeReplicationTaskAssessmentRunsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeReplicationTaskAssessmentRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationTaskAssessmentRunsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationTaskAssessmentRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationTaskAssessmentRunsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationTaskAssessmentRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationTaskAssessmentRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationTaskAssessmentRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReplicationTaskAssessmentRunsResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationTaskAssessmentRunsResponse> {
        private DescribeReplicationTaskAssessmentRunsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationTaskAssessmentRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationTaskAssessmentRunsResponse> nextPage(DescribeReplicationTaskAssessmentRunsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationTaskAssessmentRunsPublisher.this.client.describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsPublisher.this.firstRequest);
            }
            return DescribeReplicationTaskAssessmentRunsPublisher.this.client.describeReplicationTaskAssessmentRuns((DescribeReplicationTaskAssessmentRunsRequest)((Object)DescribeReplicationTaskAssessmentRunsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

