/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClientBuilder;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationServiceClientConfiguration;
import software.amazon.awssdk.services.databasemigration.DefaultDatabaseMigrationBaseClientBuilder;
import software.amazon.awssdk.services.databasemigration.DefaultDatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.endpoints.DatabaseMigrationEndpointProvider;

@SdkInternalApi
final class DefaultDatabaseMigrationClientBuilder
extends DefaultDatabaseMigrationBaseClientBuilder<DatabaseMigrationClientBuilder, DatabaseMigrationClient>
implements DatabaseMigrationClientBuilder {
    DefaultDatabaseMigrationClientBuilder() {
    }

    @Override
    public DefaultDatabaseMigrationClientBuilder endpointProvider(DatabaseMigrationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DatabaseMigrationClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDatabaseMigrationClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DatabaseMigrationServiceClientConfiguration serviceClientConfiguration = DatabaseMigrationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDatabaseMigrationClient(serviceClientConfiguration, clientConfiguration);
    }
}

