/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsErrorEntry;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsErrorEntryListCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStartRecommendationsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, BatchStartRecommendationsResponse> {
    private static final SdkField<List<BatchStartRecommendationsErrorEntry>> ERROR_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorEntries").getter(BatchStartRecommendationsResponse.getter(BatchStartRecommendationsResponse::errorEntries)).setter(BatchStartRecommendationsResponse.setter(Builder::errorEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchStartRecommendationsErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD));
    private final List<BatchStartRecommendationsErrorEntry> errorEntries;

    private BatchStartRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
    }

    public final boolean hasErrorEntries() {
        return this.errorEntries != null && !(this.errorEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchStartRecommendationsErrorEntry> errorEntries() {
        return this.errorEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorEntries() ? this.errorEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStartRecommendationsResponse)) {
            return false;
        }
        BatchStartRecommendationsResponse other = (BatchStartRecommendationsResponse)((Object)obj);
        return this.hasErrorEntries() == other.hasErrorEntries() && Objects.equals(this.errorEntries(), other.errorEntries());
    }

    public final String toString() {
        return ToString.builder((String)"BatchStartRecommendationsResponse").add("ErrorEntries", this.hasErrorEntries() ? this.errorEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorEntries": {
                return Optional.ofNullable(clazz.cast(this.errorEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStartRecommendationsResponse, T> g) {
        return obj -> g.apply((BatchStartRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<BatchStartRecommendationsErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStartRecommendationsResponse model) {
            super(model);
            this.errorEntries(model.errorEntries);
        }

        public final List<BatchStartRecommendationsErrorEntry.Builder> getErrorEntries() {
            List<BatchStartRecommendationsErrorEntry.Builder> result = BatchStartRecommendationsErrorEntryListCopier.copyToBuilder(this.errorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorEntries(Collection<BatchStartRecommendationsErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = BatchStartRecommendationsErrorEntryListCopier.copyFromBuilder(errorEntries);
        }

        @Override
        public final Builder errorEntries(Collection<BatchStartRecommendationsErrorEntry> errorEntries) {
            this.errorEntries = BatchStartRecommendationsErrorEntryListCopier.copy(errorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(BatchStartRecommendationsErrorEntry ... errorEntries) {
            this.errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(Consumer<BatchStartRecommendationsErrorEntry.Builder> ... errorEntries) {
            this.errorEntries(Stream.of(errorEntries).map(c -> (BatchStartRecommendationsErrorEntry)((BatchStartRecommendationsErrorEntry.Builder)BatchStartRecommendationsErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchStartRecommendationsResponse build() {
            return new BatchStartRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchStartRecommendationsResponse> {
        public Builder errorEntries(Collection<BatchStartRecommendationsErrorEntry> var1);

        public Builder errorEntries(BatchStartRecommendationsErrorEntry ... var1);

        public Builder errorEntries(Consumer<BatchStartRecommendationsErrorEntry.Builder> ... var1);
    }
}

