/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncodingTypeValue {
    PLAIN("plain"),
    PLAIN_DICTIONARY("plain-dictionary"),
    RLE_DICTIONARY("rle-dictionary"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EncodingTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncodingTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EncodingTypeValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncodingTypeValue> knownValues() {
        return Stream.of(EncodingTypeValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

