/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KafkaSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KafkaSettings> {
    private static final SdkField<String> BROKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KafkaSettings.getter(KafkaSettings::broker)).setter(KafkaSettings.setter(Builder::broker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Broker").build()}).build();
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KafkaSettings.getter(KafkaSettings::topic)).setter(KafkaSettings.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_FIELD, TOPIC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String broker;
    private final String topic;

    private KafkaSettings(BuilderImpl builder) {
        this.broker = builder.broker;
        this.topic = builder.topic;
    }

    public String broker() {
        return this.broker;
    }

    public String topic() {
        return this.topic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.broker());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaSettings)) {
            return false;
        }
        KafkaSettings other = (KafkaSettings)obj;
        return Objects.equals(this.broker(), other.broker()) && Objects.equals(this.topic(), other.topic());
    }

    public String toString() {
        return ToString.builder((String)"KafkaSettings").add("Broker", (Object)this.broker()).add("Topic", (Object)this.topic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Broker": {
                return Optional.ofNullable(clazz.cast(this.broker()));
            }
            case "Topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaSettings, T> g) {
        return obj -> g.apply((KafkaSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String broker;
        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaSettings model) {
            this.broker(model.broker);
            this.topic(model.topic);
        }

        public final String getBroker() {
            return this.broker;
        }

        @Override
        public final Builder broker(String broker) {
            this.broker = broker;
            return this;
        }

        public final void setBroker(String broker) {
            this.broker = broker;
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public KafkaSettings build() {
            return new KafkaSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KafkaSettings> {
        public Builder broker(String var1);

        public Builder topic(String var1);
    }
}

