/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse;

public class DescribeEventSubscriptionsIterable
implements SdkIterable<DescribeEventSubscriptionsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeEventSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventSubscriptionsIterable(DatabaseMigrationClient client, DescribeEventSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventSubscriptionsResponseFetcher();
    }

    public Iterator<DescribeEventSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeEventSubscriptionsIterable resume(DescribeEventSubscriptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventSubscriptionsIterable(this.client, (DescribeEventSubscriptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEventSubscriptionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEventSubscriptionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEventSubscriptionsResponseFetcher
    implements SyncPageFetcher<DescribeEventSubscriptionsResponse> {
        private DescribeEventSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEventSubscriptionsResponse nextPage(DescribeEventSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventSubscriptionsIterable.this.client.describeEventSubscriptions(DescribeEventSubscriptionsIterable.this.firstRequest);
            }
            return DescribeEventSubscriptionsIterable.this.client.describeEventSubscriptions((DescribeEventSubscriptionsRequest)((Object)DescribeEventSubscriptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

