/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.databasemigration.model.TableStatistics;

public class TableStatisticsUnmarshaller
implements Unmarshaller<TableStatistics, JsonUnmarshallerContext> {
    private static final TableStatisticsUnmarshaller INSTANCE = new TableStatisticsUnmarshaller();

    public TableStatistics unmarshall(JsonUnmarshallerContext context) throws Exception {
        TableStatistics.Builder tableStatisticsBuilder = TableStatistics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SchemaName", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.schemaName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Inserts", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.inserts((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Deletes", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.deletes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Updates", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.updates((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Ddls", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.ddls((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("FullLoadRows", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.fullLoadRows((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("FullLoadCondtnlChkFailedRows", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.fullLoadCondtnlChkFailedRows((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("FullLoadErrorRows", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.fullLoadErrorRows((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdateTime", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.lastUpdateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableState", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.tableState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidationPendingRecords", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.validationPendingRecords((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidationFailedRecords", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.validationFailedRecords((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidationSuspendedRecords", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.validationSuspendedRecords((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidationState", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.validationState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidationStateDetails", targetDepth)) {
                    context.nextToken();
                    tableStatisticsBuilder.validationStateDetails((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TableStatistics)tableStatisticsBuilder.build();
    }

    public static TableStatisticsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

