/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartReplicationTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> REPLICATIONTASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskArn").isBinary(false).build();
    private static final MarshallingInfo<String> STARTREPLICATIONTASKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartReplicationTaskType").isBinary(false).build();
    private static final MarshallingInfo<Instant> CDCSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartTime").isBinary(false).build();
    private static final MarshallingInfo<String> CDCSTARTPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartPosition").isBinary(false).build();
    private static final MarshallingInfo<String> CDCSTOPPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStopPosition").isBinary(false).build();
    private static final StartReplicationTaskRequestModelMarshaller INSTANCE = new StartReplicationTaskRequestModelMarshaller();

    private StartReplicationTaskRequestModelMarshaller() {
    }

    public static StartReplicationTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartReplicationTaskRequest startReplicationTaskRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startReplicationTaskRequest), (String)"startReplicationTaskRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startReplicationTaskRequest.replicationTaskArn(), REPLICATIONTASKARN_BINDING);
            protocolMarshaller.marshall((Object)startReplicationTaskRequest.startReplicationTaskTypeAsString(), STARTREPLICATIONTASKTYPE_BINDING);
            protocolMarshaller.marshall((Object)startReplicationTaskRequest.cdcStartTime(), CDCSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)startReplicationTaskRequest.cdcStartPosition(), CDCSTARTPOSITION_BINDING);
            protocolMarshaller.marshall((Object)startReplicationTaskRequest.cdcStopPosition(), CDCSTOPPOSITION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

