/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationInstanceMarshaller {
    private static final MarshallingInfo<String> REPLICATIONINSTANCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceClass").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceStatus").isBinary(false).build();
    private static final MarshallingInfo<Integer> ALLOCATEDSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllocatedStorage").isBinary(false).build();
    private static final MarshallingInfo<Instant> INSTANCECREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCreateTime").isBinary(false).build();
    private static final MarshallingInfo<List> VPCSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcSecurityGroups").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REPLICATIONSUBNETGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationSubnetGroup").isBinary(false).build();
    private static final MarshallingInfo<String> PREFERREDMAINTENANCEWINDOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreferredMaintenanceWindow").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PENDINGMODIFIEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PendingModifiedValues").isBinary(false).build();
    private static final MarshallingInfo<Boolean> MULTIAZ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiAZ").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AUTOMINORVERSIONUPGRADE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoMinorVersionUpgrade").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceArn").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCEPUBLICIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstancePublicIpAddress").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCEPRIVATEIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstancePrivateIpAddress").isBinary(false).build();
    private static final MarshallingInfo<List> REPLICATIONINSTANCEPUBLICIPADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstancePublicIpAddresses").isBinary(false).build();
    private static final MarshallingInfo<List> REPLICATIONINSTANCEPRIVATEIPADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstancePrivateIpAddresses").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PUBLICLYACCESSIBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PubliclyAccessible").isBinary(false).build();
    private static final MarshallingInfo<String> SECONDARYAVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecondaryAvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<Instant> FREEUNTIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FreeUntil").isBinary(false).build();
    private static final ReplicationInstanceMarshaller INSTANCE = new ReplicationInstanceMarshaller();

    private ReplicationInstanceMarshaller() {
    }

    public static ReplicationInstanceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationInstance replicationInstance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationInstance, (String)"replicationInstance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationInstance.replicationInstanceIdentifier(), REPLICATIONINSTANCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.replicationInstanceClass(), REPLICATIONINSTANCECLASS_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.replicationInstanceStatus(), REPLICATIONINSTANCESTATUS_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.allocatedStorage(), ALLOCATEDSTORAGE_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.instanceCreateTime(), INSTANCECREATETIME_BINDING);
            protocolMarshaller.marshall(replicationInstance.vpcSecurityGroups(), VPCSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.replicationSubnetGroup(), REPLICATIONSUBNETGROUP_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.preferredMaintenanceWindow(), PREFERREDMAINTENANCEWINDOW_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.pendingModifiedValues(), PENDINGMODIFIEDVALUES_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.multiAZ(), MULTIAZ_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.engineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.autoMinorVersionUpgrade(), AUTOMINORVERSIONUPGRADE_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.replicationInstanceArn(), REPLICATIONINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.replicationInstancePublicIpAddress(), REPLICATIONINSTANCEPUBLICIPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.replicationInstancePrivateIpAddress(), REPLICATIONINSTANCEPRIVATEIPADDRESS_BINDING);
            protocolMarshaller.marshall(replicationInstance.replicationInstancePublicIpAddresses(), REPLICATIONINSTANCEPUBLICIPADDRESSES_BINDING);
            protocolMarshaller.marshall(replicationInstance.replicationInstancePrivateIpAddresses(), REPLICATIONINSTANCEPRIVATEIPADDRESSES_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.publiclyAccessible(), PUBLICLYACCESSIBLE_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.secondaryAvailabilityZone(), SECONDARYAVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)replicationInstance.freeUntil(), FREEUNTIL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

