/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RefreshSchemasStatusMarshaller {
    private static final MarshallingInfo<String> ENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointArn").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceArn").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTREFRESHDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastRefreshDate").isBinary(false).build();
    private static final MarshallingInfo<String> LASTFAILUREMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastFailureMessage").isBinary(false).build();
    private static final RefreshSchemasStatusMarshaller INSTANCE = new RefreshSchemasStatusMarshaller();

    private RefreshSchemasStatusMarshaller() {
    }

    public static RefreshSchemasStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RefreshSchemasStatus refreshSchemasStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)refreshSchemasStatus, (String)"refreshSchemasStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)refreshSchemasStatus.endpointArn(), ENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)refreshSchemasStatus.replicationInstanceArn(), REPLICATIONINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)refreshSchemasStatus.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)refreshSchemasStatus.lastRefreshDate(), LASTREFRESHDATE_BINDING);
            protocolMarshaller.marshall((Object)refreshSchemasStatus.lastFailureMessage(), LASTFAILUREMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

