/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModifyEndpointRequestModelMarshaller {
    private static final MarshallingInfo<String> ENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointArn").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointType").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineName").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").isBinary(false).build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> EXTRACONNECTIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraConnectionAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> SSLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslMode").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccessRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALTABLEDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalTableDefinition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DYNAMODBSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DynamoDbSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Settings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DMSTRANSFERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DmsTransferSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MONGODBSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MongoDbSettings").isBinary(false).build();
    private static final ModifyEndpointRequestModelMarshaller INSTANCE = new ModifyEndpointRequestModelMarshaller();

    private ModifyEndpointRequestModelMarshaller() {
    }

    public static ModifyEndpointRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModifyEndpointRequest modifyEndpointRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)modifyEndpointRequest), (String)"modifyEndpointRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modifyEndpointRequest.endpointArn(), ENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.endpointIdentifier(), ENDPOINTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.endpointTypeAsString(), ENDPOINTTYPE_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.engineName(), ENGINENAME_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.serverName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.port(), PORT_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.extraConnectionAttributes(), EXTRACONNECTIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.sslModeAsString(), SSLMODE_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.serviceAccessRoleArn(), SERVICEACCESSROLEARN_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.externalTableDefinition(), EXTERNALTABLEDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.dynamoDbSettings(), DYNAMODBSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.s3Settings(), S3SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.dmsTransferSettings(), DMSTRANSFERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)modifyEndpointRequest.mongoDbSettings(), MONGODBSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

