/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateReplicationTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> REPLICATIONTASKIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceEndpointArn").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetEndpointArn").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceArn").isBinary(false).build();
    private static final MarshallingInfo<String> MIGRATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MigrationType").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableMappings").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONTASKSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskSettings").isBinary(false).build();
    private static final MarshallingInfo<Instant> CDCSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartTime").isBinary(false).build();
    private static final MarshallingInfo<String> CDCSTARTPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartPosition").isBinary(false).build();
    private static final MarshallingInfo<String> CDCSTOPPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStopPosition").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final CreateReplicationTaskRequestModelMarshaller INSTANCE = new CreateReplicationTaskRequestModelMarshaller();

    private CreateReplicationTaskRequestModelMarshaller() {
    }

    public static CreateReplicationTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateReplicationTaskRequest createReplicationTaskRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createReplicationTaskRequest), (String)"createReplicationTaskRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.replicationTaskIdentifier(), REPLICATIONTASKIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.sourceEndpointArn(), SOURCEENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.targetEndpointArn(), TARGETENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.replicationInstanceArn(), REPLICATIONINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.migrationTypeAsString(), MIGRATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.tableMappings(), TABLEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.replicationTaskSettings(), REPLICATIONTASKSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.cdcStartTime(), CDCSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.cdcStartPosition(), CDCSTARTPOSITION_BINDING);
            protocolMarshaller.marshall((Object)createReplicationTaskRequest.cdcStopPosition(), CDCSTOPPOSITION_BINDING);
            protocolMarshaller.marshall(createReplicationTaskRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

