/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateReplicationSubnetGroupRequestModelMarshaller {
    private static final MarshallingInfo<String> REPLICATIONSUBNETGROUPIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationSubnetGroupIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONSUBNETGROUPDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationSubnetGroupDescription").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final CreateReplicationSubnetGroupRequestModelMarshaller INSTANCE = new CreateReplicationSubnetGroupRequestModelMarshaller();

    private CreateReplicationSubnetGroupRequestModelMarshaller() {
    }

    public static CreateReplicationSubnetGroupRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createReplicationSubnetGroupRequest), (String)"createReplicationSubnetGroupRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createReplicationSubnetGroupRequest.replicationSubnetGroupIdentifier(), REPLICATIONSUBNETGROUPIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)createReplicationSubnetGroupRequest.replicationSubnetGroupDescription(), REPLICATIONSUBNETGROUPDESCRIPTION_BINDING);
            protocolMarshaller.marshall(createReplicationSubnetGroupRequest.subnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(createReplicationSubnetGroupRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

