/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateEventSubscriptionRequestModelMarshaller {
    private static final MarshallingInfo<String> SUBSCRIPTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionName").isBinary(false).build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicArn").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTCATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventCategories").isBinary(false).build();
    private static final MarshallingInfo<List> SOURCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceIds").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final CreateEventSubscriptionRequestModelMarshaller INSTANCE = new CreateEventSubscriptionRequestModelMarshaller();

    private CreateEventSubscriptionRequestModelMarshaller() {
    }

    public static CreateEventSubscriptionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateEventSubscriptionRequest createEventSubscriptionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createEventSubscriptionRequest), (String)"createEventSubscriptionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createEventSubscriptionRequest.subscriptionName(), SUBSCRIPTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)createEventSubscriptionRequest.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall((Object)createEventSubscriptionRequest.sourceType(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall(createEventSubscriptionRequest.eventCategories(), EVENTCATEGORIES_BINDING);
            protocolMarshaller.marshall(createEventSubscriptionRequest.sourceIds(), SOURCEIDS_BINDING);
            protocolMarshaller.marshall((Object)createEventSubscriptionRequest.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(createEventSubscriptionRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

