/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.databasemigration.model.Certificate;

public class CertificateUnmarshaller
implements Unmarshaller<Certificate, JsonUnmarshallerContext> {
    private static final CertificateUnmarshaller INSTANCE = new CertificateUnmarshaller();

    public Certificate unmarshall(JsonUnmarshallerContext context) throws Exception {
        Certificate.Builder certificateBuilder = Certificate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CertificateIdentifier", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.certificateIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CertificateCreationDate", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.certificateCreationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("CertificatePem", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.certificatePem((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CertificateWallet", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.certificateWallet((SdkBytes)context.getUnmarshaller(SdkBytes.class).unmarshall((Object)context));
                }
                if (context.testExpression("CertificateArn", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.certificateArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CertificateOwner", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.certificateOwner((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidFromDate", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.validFromDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidToDate", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.validToDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("SigningAlgorithm", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.signingAlgorithm((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeyLength", targetDepth)) {
                    context.nextToken();
                    certificateBuilder.keyLength((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Certificate)certificateBuilder.build();
    }

    public static CertificateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

