/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.EventCategoryGroup;
import software.amazon.awssdk.services.databasemigration.model.EventCategoryGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventCategoriesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeEventCategoriesResponse> {
    private final List<EventCategoryGroup> eventCategoryGroupList;

    private DescribeEventCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.eventCategoryGroupList = builder.eventCategoryGroupList;
    }

    public List<EventCategoryGroup> eventCategoryGroupList() {
        return this.eventCategoryGroupList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategoryGroupList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventCategoriesResponse)) {
            return false;
        }
        DescribeEventCategoriesResponse other = (DescribeEventCategoriesResponse)((Object)obj);
        return Objects.equals(this.eventCategoryGroupList(), other.eventCategoryGroupList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventCategoriesResponse").add("EventCategoryGroupList", this.eventCategoryGroupList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventCategoryGroupList": {
                return Optional.ofNullable(clazz.cast(this.eventCategoryGroupList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<EventCategoryGroup> eventCategoryGroupList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventCategoriesResponse model) {
            super(model);
            this.eventCategoryGroupList(model.eventCategoryGroupList);
        }

        public final Collection<EventCategoryGroup.Builder> getEventCategoryGroupList() {
            return this.eventCategoryGroupList != null ? (Collection)this.eventCategoryGroupList.stream().map(EventCategoryGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventCategoryGroupList(Collection<EventCategoryGroup> eventCategoryGroupList) {
            this.eventCategoryGroupList = EventCategoryGroupListCopier.copy(eventCategoryGroupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoryGroupList(EventCategoryGroup ... eventCategoryGroupList) {
            this.eventCategoryGroupList(Arrays.asList(eventCategoryGroupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoryGroupList(Consumer<EventCategoryGroup.Builder> ... eventCategoryGroupList) {
            this.eventCategoryGroupList(Stream.of(eventCategoryGroupList).map(c -> (EventCategoryGroup)((EventCategoryGroup.Builder)EventCategoryGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventCategoryGroupList(Collection<EventCategoryGroup.BuilderImpl> eventCategoryGroupList) {
            this.eventCategoryGroupList = EventCategoryGroupListCopier.copyFromBuilder(eventCategoryGroupList);
        }

        @Override
        public DescribeEventCategoriesResponse build() {
            return new DescribeEventCategoriesResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeEventCategoriesResponse> {
        public Builder eventCategoryGroupList(Collection<EventCategoryGroup> var1);

        public Builder eventCategoryGroupList(EventCategoryGroup ... var1);

        public Builder eventCategoryGroupList(Consumer<EventCategoryGroup.Builder> ... var1);
    }
}

