/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType;
import software.amazon.awssdk.services.databasemigration.model.SupportedEndpointTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointTypesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeEndpointTypesResponse> {
    private final String marker;
    private final List<SupportedEndpointType> supportedEndpointTypes;

    private DescribeEndpointTypesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.supportedEndpointTypes = builder.supportedEndpointTypes;
    }

    public String marker() {
        return this.marker;
    }

    public List<SupportedEndpointType> supportedEndpointTypes() {
        return this.supportedEndpointTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedEndpointTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointTypesResponse)) {
            return false;
        }
        DescribeEndpointTypesResponse other = (DescribeEndpointTypesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.supportedEndpointTypes(), other.supportedEndpointTypes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEndpointTypesResponse").add("Marker", (Object)this.marker()).add("SupportedEndpointTypes", this.supportedEndpointTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "SupportedEndpointTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedEndpointTypes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<SupportedEndpointType> supportedEndpointTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointTypesResponse model) {
            super(model);
            this.marker(model.marker);
            this.supportedEndpointTypes(model.supportedEndpointTypes);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<SupportedEndpointType.Builder> getSupportedEndpointTypes() {
            return this.supportedEndpointTypes != null ? (Collection)this.supportedEndpointTypes.stream().map(SupportedEndpointType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedEndpointTypes(Collection<SupportedEndpointType> supportedEndpointTypes) {
            this.supportedEndpointTypes = SupportedEndpointTypeListCopier.copy(supportedEndpointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEndpointTypes(SupportedEndpointType ... supportedEndpointTypes) {
            this.supportedEndpointTypes(Arrays.asList(supportedEndpointTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEndpointTypes(Consumer<SupportedEndpointType.Builder> ... supportedEndpointTypes) {
            this.supportedEndpointTypes(Stream.of(supportedEndpointTypes).map(c -> (SupportedEndpointType)((SupportedEndpointType.Builder)SupportedEndpointType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedEndpointTypes(Collection<SupportedEndpointType.BuilderImpl> supportedEndpointTypes) {
            this.supportedEndpointTypes = SupportedEndpointTypeListCopier.copyFromBuilder(supportedEndpointTypes);
        }

        @Override
        public DescribeEndpointTypesResponse build() {
            return new DescribeEndpointTypesResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeEndpointTypesResponse> {
        public Builder marker(String var1);

        public Builder supportedEndpointTypes(Collection<SupportedEndpointType> var1);

        public Builder supportedEndpointTypes(SupportedEndpointType ... var1);

        public Builder supportedEndpointTypes(Consumer<SupportedEndpointType.Builder> ... var1);
    }
}

