/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationTaskRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateReplicationTaskRequest> {
    private final String replicationTaskIdentifier;
    private final String sourceEndpointArn;
    private final String targetEndpointArn;
    private final String replicationInstanceArn;
    private final String migrationType;
    private final String tableMappings;
    private final String replicationTaskSettings;
    private final Instant cdcStartTime;
    private final String cdcStartPosition;
    private final String cdcStopPosition;
    private final List<Tag> tags;

    private CreateReplicationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.migrationType = builder.migrationType;
        this.tableMappings = builder.tableMappings;
        this.replicationTaskSettings = builder.replicationTaskSettings;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
        this.tags = builder.tags;
    }

    public String replicationTaskIdentifier() {
        return this.replicationTaskIdentifier;
    }

    public String sourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    public String targetEndpointArn() {
        return this.targetEndpointArn;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(this.migrationType);
    }

    public String migrationTypeAsString() {
        return this.migrationType;
    }

    public String tableMappings() {
        return this.tableMappings;
    }

    public String replicationTaskSettings() {
        return this.replicationTaskSettings;
    }

    public Instant cdcStartTime() {
        return this.cdcStartTime;
    }

    public String cdcStartPosition() {
        return this.cdcStartPosition;
    }

    public String cdcStopPosition() {
        return this.cdcStopPosition;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStopPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationTaskRequest)) {
            return false;
        }
        CreateReplicationTaskRequest other = (CreateReplicationTaskRequest)((Object)obj);
        return Objects.equals(this.replicationTaskIdentifier(), other.replicationTaskIdentifier()) && Objects.equals(this.sourceEndpointArn(), other.sourceEndpointArn()) && Objects.equals(this.targetEndpointArn(), other.targetEndpointArn()) && Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.migrationTypeAsString(), other.migrationTypeAsString()) && Objects.equals(this.tableMappings(), other.tableMappings()) && Objects.equals(this.replicationTaskSettings(), other.replicationTaskSettings()) && Objects.equals(this.cdcStartTime(), other.cdcStartTime()) && Objects.equals(this.cdcStartPosition(), other.cdcStartPosition()) && Objects.equals(this.cdcStopPosition(), other.cdcStopPosition()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateReplicationTaskRequest").add("ReplicationTaskIdentifier", (Object)this.replicationTaskIdentifier()).add("SourceEndpointArn", (Object)this.sourceEndpointArn()).add("TargetEndpointArn", (Object)this.targetEndpointArn()).add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("MigrationType", (Object)this.migrationTypeAsString()).add("TableMappings", (Object)this.tableMappings()).add("ReplicationTaskSettings", (Object)this.replicationTaskSettings()).add("CdcStartTime", (Object)this.cdcStartTime()).add("CdcStartPosition", (Object)this.cdcStartPosition()).add("CdcStopPosition", (Object)this.cdcStopPosition()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskIdentifier()));
            }
            case "SourceEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEndpointArn()));
            }
            case "TargetEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.targetEndpointArn()));
            }
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "MigrationType": {
                return Optional.ofNullable(clazz.cast(this.migrationTypeAsString()));
            }
            case "TableMappings": {
                return Optional.ofNullable(clazz.cast(this.tableMappings()));
            }
            case "ReplicationTaskSettings": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskSettings()));
            }
            case "CdcStartTime": {
                return Optional.ofNullable(clazz.cast(this.cdcStartTime()));
            }
            case "CdcStartPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStartPosition()));
            }
            case "CdcStopPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStopPosition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationTaskIdentifier;
        private String sourceEndpointArn;
        private String targetEndpointArn;
        private String replicationInstanceArn;
        private String migrationType;
        private String tableMappings;
        private String replicationTaskSettings;
        private Instant cdcStartTime;
        private String cdcStartPosition;
        private String cdcStopPosition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationTaskRequest model) {
            super(model);
            this.replicationTaskIdentifier(model.replicationTaskIdentifier);
            this.sourceEndpointArn(model.sourceEndpointArn);
            this.targetEndpointArn(model.targetEndpointArn);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.migrationType(model.migrationType);
            this.tableMappings(model.tableMappings);
            this.replicationTaskSettings(model.replicationTaskSettings);
            this.cdcStartTime(model.cdcStartTime);
            this.cdcStartPosition(model.cdcStartPosition);
            this.cdcStopPosition(model.cdcStopPosition);
            this.tags(model.tags);
        }

        public final String getReplicationTaskIdentifier() {
            return this.replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        public final String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        public final String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getMigrationType() {
            return this.migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType.toString());
            return this;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        public final String getTableMappings() {
            return this.tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        public final String getReplicationTaskSettings() {
            return this.replicationTaskSettings;
        }

        @Override
        public final Builder replicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        public final void setReplicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
        }

        public final Instant getCdcStartTime() {
            return this.cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        public final String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        public final String getCdcStopPosition() {
            return this.cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationTaskRequest build() {
            return new CreateReplicationTaskRequest(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    CopyableBuilder<Builder, CreateReplicationTaskRequest> {
        public Builder replicationTaskIdentifier(String var1);

        public Builder sourceEndpointArn(String var1);

        public Builder targetEndpointArn(String var1);

        public Builder replicationInstanceArn(String var1);

        public Builder migrationType(String var1);

        public Builder migrationType(MigrationTypeValue var1);

        public Builder tableMappings(String var1);

        public Builder replicationTaskSettings(String var1);

        public Builder cdcStartTime(Instant var1);

        public Builder cdcStartPosition(String var1);

        public Builder cdcStopPosition(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

