/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.LayoutItem;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsResponse;

public class ListDomainLayoutsPublisher
implements SdkPublisher<ListDomainLayoutsResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListDomainLayoutsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainLayoutsPublisher(CustomerProfilesAsyncClient client, ListDomainLayoutsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainLayoutsPublisher(CustomerProfilesAsyncClient client, ListDomainLayoutsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainLayoutsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainLayoutsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LayoutItem> items() {
        Function<ListDomainLayoutsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDomainLayoutsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainLayoutsResponseFetcher
    implements AsyncPageFetcher<ListDomainLayoutsResponse> {
        private ListDomainLayoutsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainLayoutsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDomainLayoutsResponse> nextPage(ListDomainLayoutsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainLayoutsPublisher.this.client.listDomainLayouts(ListDomainLayoutsPublisher.this.firstRequest);
            }
            return ListDomainLayoutsPublisher.this.client.listDomainLayouts((ListDomainLayoutsRequest)((Object)ListDomainLayoutsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

