/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecommenderRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, UpdateRecommenderRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateRecommenderRequest.getter(UpdateRecommenderRequest::domainName)).setter(UpdateRecommenderRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> RECOMMENDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderName").getter(UpdateRecommenderRequest.getter(UpdateRecommenderRequest::recommenderName)).setter(UpdateRecommenderRequest.setter(Builder::recommenderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RecommenderName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateRecommenderRequest.getter(UpdateRecommenderRequest::description)).setter(UpdateRecommenderRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecommenderConfig").getter(UpdateRecommenderRequest.getter(UpdateRecommenderRequest::recommenderConfig)).setter(UpdateRecommenderRequest.setter(Builder::recommenderConfig)).constructor(RecommenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, RECOMMENDER_NAME_FIELD, DESCRIPTION_FIELD, RECOMMENDER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRecommenderRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String recommenderName;
    private final String description;
    private final RecommenderConfig recommenderConfig;

    private UpdateRecommenderRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.recommenderName = builder.recommenderName;
        this.description = builder.description;
        this.recommenderConfig = builder.recommenderConfig;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String recommenderName() {
        return this.recommenderName;
    }

    public final String description() {
        return this.description;
    }

    public final RecommenderConfig recommenderConfig() {
        return this.recommenderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecommenderRequest)) {
            return false;
        }
        UpdateRecommenderRequest other = (UpdateRecommenderRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.recommenderName(), other.recommenderName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.recommenderConfig(), other.recommenderConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecommenderRequest").add("DomainName", (Object)this.domainName()).add("RecommenderName", (Object)this.recommenderName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("RecommenderConfig", (Object)this.recommenderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "RecommenderName": {
                return Optional.ofNullable(clazz.cast(this.recommenderName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RecommenderConfig": {
                return Optional.ofNullable(clazz.cast(this.recommenderConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("RecommenderName", RECOMMENDER_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RecommenderConfig", RECOMMENDER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecommenderRequest, T> g) {
        return obj -> g.apply((UpdateRecommenderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String recommenderName;
        private String description;
        private RecommenderConfig recommenderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecommenderRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.recommenderName(model.recommenderName);
            this.description(model.description);
            this.recommenderConfig(model.recommenderConfig);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getRecommenderName() {
            return this.recommenderName;
        }

        public final void setRecommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
        }

        @Override
        public final Builder recommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return this.recommenderConfig != null ? this.recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecommenderRequest build() {
            return new UpdateRecommenderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecommenderRequest> {
        public Builder domainName(String var1);

        public Builder recommenderName(String var1);

        public Builder description(String var1);

        public Builder recommenderConfig(RecommenderConfig var1);

        default public Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return this.recommenderConfig((RecommenderConfig)((RecommenderConfig.Builder)RecommenderConfig.builder().applyMutation(recommenderConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

