/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Scope {
    PROFILE("PROFILE"),
    DOMAIN("DOMAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Scope> VALUE_MAP;
    private final String value;

    private Scope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Scope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Scope> knownValues() {
        EnumSet<Scope> knownValues = EnumSet.allOf(Scope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Scope.class, Scope::toString);
    }
}

