/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommenderRecipeName {
    RECOMMENDED_FOR_YOU("recommended-for-you"),
    SIMILAR_ITEMS("similar-items"),
    FREQUENTLY_PAIRED_ITEMS("frequently-paired-items"),
    POPULAR_ITEMS("popular-items"),
    TRENDING_NOW("trending-now"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommenderRecipeName> VALUE_MAP;
    private final String value;

    private RecommenderRecipeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommenderRecipeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommenderRecipeName> knownValues() {
        EnumSet<RecommenderRecipeName> knownValues = EnumSet.allOf(RecommenderRecipeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommenderRecipeName.class, RecommenderRecipeName::toString);
    }
}

