/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.Period;
import software.amazon.awssdk.services.customerprofiles.model.PeriodsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventTriggerLimits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventTriggerLimits> {
    private static final SdkField<Long> EVENT_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EventExpiration").getter(EventTriggerLimits.getter(EventTriggerLimits::eventExpiration)).setter(EventTriggerLimits.setter(Builder::eventExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventExpiration").build()}).build();
    private static final SdkField<List<Period>> PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Periods").getter(EventTriggerLimits.getter(EventTriggerLimits::periods)).setter(EventTriggerLimits.setter(Builder::periods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Periods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Period::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_EXPIRATION_FIELD, PERIODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventTriggerLimits.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long eventExpiration;
    private final List<Period> periods;

    private EventTriggerLimits(BuilderImpl builder) {
        this.eventExpiration = builder.eventExpiration;
        this.periods = builder.periods;
    }

    public final Long eventExpiration() {
        return this.eventExpiration;
    }

    public final boolean hasPeriods() {
        return this.periods != null && !(this.periods instanceof SdkAutoConstructList);
    }

    public final List<Period> periods() {
        return this.periods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeriods() ? this.periods() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTriggerLimits)) {
            return false;
        }
        EventTriggerLimits other = (EventTriggerLimits)obj;
        return Objects.equals(this.eventExpiration(), other.eventExpiration()) && this.hasPeriods() == other.hasPeriods() && Objects.equals(this.periods(), other.periods());
    }

    public final String toString() {
        return ToString.builder((String)"EventTriggerLimits").add("EventExpiration", (Object)this.eventExpiration()).add("Periods", this.hasPeriods() ? this.periods() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventExpiration": {
                return Optional.ofNullable(clazz.cast(this.eventExpiration()));
            }
            case "Periods": {
                return Optional.ofNullable(clazz.cast(this.periods()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventExpiration", EVENT_EXPIRATION_FIELD);
        map.put("Periods", PERIODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTriggerLimits, T> g) {
        return obj -> g.apply((EventTriggerLimits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long eventExpiration;
        private List<Period> periods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventTriggerLimits model) {
            this.eventExpiration(model.eventExpiration);
            this.periods(model.periods);
        }

        public final Long getEventExpiration() {
            return this.eventExpiration;
        }

        public final void setEventExpiration(Long eventExpiration) {
            this.eventExpiration = eventExpiration;
        }

        @Override
        public final Builder eventExpiration(Long eventExpiration) {
            this.eventExpiration = eventExpiration;
            return this;
        }

        public final List<Period.Builder> getPeriods() {
            List<Period.Builder> result = PeriodsCopier.copyToBuilder(this.periods);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPeriods(Collection<Period.BuilderImpl> periods) {
            this.periods = PeriodsCopier.copyFromBuilder(periods);
        }

        @Override
        public final Builder periods(Collection<Period> periods) {
            this.periods = PeriodsCopier.copy(periods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periods(Period ... periods) {
            this.periods(Arrays.asList(periods));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periods(Consumer<Period.Builder> ... periods) {
            this.periods(Stream.of(periods).map(c -> (Period)((Period.Builder)Period.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EventTriggerLimits build() {
            return new EventTriggerLimits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventTriggerLimits> {
        public Builder eventExpiration(Long var1);

        public Builder periods(Collection<Period> var1);

        public Builder periods(Period ... var1);

        public Builder periods(Consumer<Period.Builder> ... var1);
    }
}

