/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ObjectsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectProfileObjectTypeRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, DetectProfileObjectTypeRequest> {
    private static final SdkField<List<String>> OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Objects").getter(DetectProfileObjectTypeRequest.getter(DetectProfileObjectTypeRequest::objects)).setter(DetectProfileObjectTypeRequest.setter(Builder::objects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DetectProfileObjectTypeRequest.getter(DetectProfileObjectTypeRequest::domainName)).setter(DetectProfileObjectTypeRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECTS_FIELD, DOMAIN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectProfileObjectTypeRequest.memberNameToFieldInitializer();
    private final List<String> objects;
    private final String domainName;

    private DetectProfileObjectTypeRequest(BuilderImpl builder) {
        super(builder);
        this.objects = builder.objects;
        this.domainName = builder.domainName;
    }

    public final boolean hasObjects() {
        return this.objects != null && !(this.objects instanceof SdkAutoConstructList);
    }

    public final List<String> objects() {
        return this.objects;
    }

    public final String domainName() {
        return this.domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjects() ? this.objects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProfileObjectTypeRequest)) {
            return false;
        }
        DetectProfileObjectTypeRequest other = (DetectProfileObjectTypeRequest)((Object)obj);
        return this.hasObjects() == other.hasObjects() && Objects.equals(this.objects(), other.objects()) && Objects.equals(this.domainName(), other.domainName());
    }

    public final String toString() {
        return ToString.builder((String)"DetectProfileObjectTypeRequest").add("Objects", (Object)(this.objects() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainName", (Object)this.domainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Objects": {
                return Optional.ofNullable(clazz.cast(this.objects()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Objects", OBJECTS_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectProfileObjectTypeRequest, T> g) {
        return obj -> g.apply((DetectProfileObjectTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private List<String> objects = DefaultSdkAutoConstructList.getInstance();
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectProfileObjectTypeRequest model) {
            super(model);
            this.objects(model.objects);
            this.domainName(model.domainName);
        }

        public final Collection<String> getObjects() {
            if (this.objects instanceof SdkAutoConstructList) {
                return null;
            }
            return this.objects;
        }

        public final void setObjects(Collection<String> objects) {
            this.objects = ObjectsCopier.copy(objects);
        }

        @Override
        public final Builder objects(Collection<String> objects) {
            this.objects = ObjectsCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(String ... objects) {
            this.objects(Arrays.asList(objects));
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectProfileObjectTypeRequest build() {
            return new DetectProfileObjectTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectProfileObjectTypeRequest> {
        public Builder objects(Collection<String> var1);

        public Builder objects(String ... var1);

        public Builder domainName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

