/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.Status;
import software.amazon.awssdk.services.customerprofiles.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowsRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, ListWorkflowsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::domainName)).setter(ListWorkflowsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowType").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::workflowTypeAsString)).setter(ListWorkflowsRequest.setter(Builder::workflowType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::statusAsString)).setter(ListWorkflowsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> QUERY_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("QueryStartDate").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::queryStartDate)).setter(ListWorkflowsRequest.setter(Builder::queryStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStartDate").build()}).build();
    private static final SdkField<Instant> QUERY_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("QueryEndDate").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::queryEndDate)).setter(ListWorkflowsRequest.setter(Builder::queryEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryEndDate").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::nextToken)).setter(ListWorkflowsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::maxResults)).setter(ListWorkflowsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, WORKFLOW_TYPE_FIELD, STATUS_FIELD, QUERY_START_DATE_FIELD, QUERY_END_DATE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("WorkflowType", WORKFLOW_TYPE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("QueryStartDate", QUERY_START_DATE_FIELD);
            this.put("QueryEndDate", QUERY_END_DATE_FIELD);
            this.put("next-token", NEXT_TOKEN_FIELD);
            this.put("max-results", MAX_RESULTS_FIELD);
        }
    });
    private final String domainName;
    private final String workflowType;
    private final String status;
    private final Instant queryStartDate;
    private final Instant queryEndDate;
    private final String nextToken;
    private final Integer maxResults;

    private ListWorkflowsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.workflowType = builder.workflowType;
        this.status = builder.status;
        this.queryStartDate = builder.queryStartDate;
        this.queryEndDate = builder.queryEndDate;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(this.workflowType);
    }

    public final String workflowTypeAsString() {
        return this.workflowType;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant queryStartDate() {
        return this.queryStartDate;
    }

    public final Instant queryEndDate() {
        return this.queryEndDate;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowsRequest)) {
            return false;
        }
        ListWorkflowsRequest other = (ListWorkflowsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.workflowTypeAsString(), other.workflowTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.queryStartDate(), other.queryStartDate()) && Objects.equals(this.queryEndDate(), other.queryEndDate()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowsRequest").add("DomainName", (Object)this.domainName()).add("WorkflowType", (Object)this.workflowTypeAsString()).add("Status", (Object)this.statusAsString()).add("QueryStartDate", (Object)this.queryStartDate()).add("QueryEndDate", (Object)this.queryEndDate()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "WorkflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "QueryStartDate": {
                return Optional.ofNullable(clazz.cast(this.queryStartDate()));
            }
            case "QueryEndDate": {
                return Optional.ofNullable(clazz.cast(this.queryEndDate()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowsRequest, T> g) {
        return obj -> g.apply((ListWorkflowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String workflowType;
        private String status;
        private Instant queryStartDate;
        private Instant queryEndDate;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.workflowType(model.workflowType);
            this.status(model.status);
            this.queryStartDate(model.queryStartDate);
            this.queryEndDate(model.queryEndDate);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getWorkflowType() {
            return this.workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getQueryStartDate() {
            return this.queryStartDate;
        }

        public final void setQueryStartDate(Instant queryStartDate) {
            this.queryStartDate = queryStartDate;
        }

        @Override
        public final Builder queryStartDate(Instant queryStartDate) {
            this.queryStartDate = queryStartDate;
            return this;
        }

        public final Instant getQueryEndDate() {
            return this.queryEndDate;
        }

        public final void setQueryEndDate(Instant queryEndDate) {
            this.queryEndDate = queryEndDate;
        }

        @Override
        public final Builder queryEndDate(Instant queryEndDate) {
            this.queryEndDate = queryEndDate;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkflowsRequest build() {
            return new ListWorkflowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowsRequest> {
        public Builder domainName(String var1);

        public Builder workflowType(String var1);

        public Builder workflowType(WorkflowType var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder queryStartDate(Instant var1);

        public Builder queryEndDate(Instant var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

