/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.AttributeDetails;
import software.amazon.awssdk.services.customerprofiles.model.Conditions;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.Statistic;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCalculatedAttributeDefinitionResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, CreateCalculatedAttributeDefinitionResponse> {
    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatedAttributeName").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::calculatedAttributeName)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::calculatedAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedAttributeName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::displayName)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::description)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AttributeDetails> ATTRIBUTE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeDetails").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::attributeDetails)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::attributeDetails)).constructor(AttributeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDetails").build()}).build();
    private static final SdkField<Conditions> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Conditions").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::conditions)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::conditions)).constructor(Conditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::statisticAsString)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::createdAt)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::lastUpdatedAt)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateCalculatedAttributeDefinitionResponse.getter(CreateCalculatedAttributeDefinitionResponse::tags)).setter(CreateCalculatedAttributeDefinitionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATED_ATTRIBUTE_NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ATTRIBUTE_DETAILS_FIELD, CONDITIONS_FIELD, STATISTIC_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CalculatedAttributeName", CALCULATED_ATTRIBUTE_NAME_FIELD);
            this.put("DisplayName", DISPLAY_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("AttributeDetails", ATTRIBUTE_DETAILS_FIELD);
            this.put("Conditions", CONDITIONS_FIELD);
            this.put("Statistic", STATISTIC_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String calculatedAttributeName;
    private final String displayName;
    private final String description;
    private final AttributeDetails attributeDetails;
    private final Conditions conditions;
    private final String statistic;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Map<String, String> tags;

    private CreateCalculatedAttributeDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.calculatedAttributeName = builder.calculatedAttributeName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.attributeDetails = builder.attributeDetails;
        this.conditions = builder.conditions;
        this.statistic = builder.statistic;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    public final String calculatedAttributeName() {
        return this.calculatedAttributeName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final AttributeDetails attributeDetails() {
        return this.attributeDetails;
    }

    public final Conditions conditions() {
        return this.conditions;
    }

    public final Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCalculatedAttributeDefinitionResponse)) {
            return false;
        }
        CreateCalculatedAttributeDefinitionResponse other = (CreateCalculatedAttributeDefinitionResponse)((Object)obj);
        return Objects.equals(this.calculatedAttributeName(), other.calculatedAttributeName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.attributeDetails(), other.attributeDetails()) && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCalculatedAttributeDefinitionResponse").add("CalculatedAttributeName", (Object)this.calculatedAttributeName()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("AttributeDetails", (Object)(this.attributeDetails() == null ? null : "*** Sensitive Data Redacted ***")).add("Conditions", (Object)(this.conditions() == null ? null : "*** Sensitive Data Redacted ***")).add("Statistic", (Object)(this.statisticAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatedAttributeName": {
                return Optional.ofNullable(clazz.cast(this.calculatedAttributeName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AttributeDetails": {
                return Optional.ofNullable(clazz.cast(this.attributeDetails()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCalculatedAttributeDefinitionResponse, T> g) {
        return obj -> g.apply((CreateCalculatedAttributeDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String calculatedAttributeName;
        private String displayName;
        private String description;
        private AttributeDetails attributeDetails;
        private Conditions conditions;
        private String statistic;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCalculatedAttributeDefinitionResponse model) {
            super(model);
            this.calculatedAttributeName(model.calculatedAttributeName);
            this.displayName(model.displayName);
            this.description(model.description);
            this.attributeDetails(model.attributeDetails);
            this.conditions(model.conditions);
            this.statistic(model.statistic);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.tags(model.tags);
        }

        public final String getCalculatedAttributeName() {
            return this.calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AttributeDetails.Builder getAttributeDetails() {
            return this.attributeDetails != null ? this.attributeDetails.toBuilder() : null;
        }

        public final void setAttributeDetails(AttributeDetails.BuilderImpl attributeDetails) {
            this.attributeDetails = attributeDetails != null ? attributeDetails.build() : null;
        }

        @Override
        public final Builder attributeDetails(AttributeDetails attributeDetails) {
            this.attributeDetails = attributeDetails;
            return this;
        }

        public final Conditions.Builder getConditions() {
            return this.conditions != null ? this.conditions.toBuilder() : null;
        }

        public final void setConditions(Conditions.BuilderImpl conditions) {
            this.conditions = conditions != null ? conditions.build() : null;
        }

        @Override
        public final Builder conditions(Conditions conditions) {
            this.conditions = conditions;
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateCalculatedAttributeDefinitionResponse build() {
            return new CreateCalculatedAttributeDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCalculatedAttributeDefinitionResponse> {
        public Builder calculatedAttributeName(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder attributeDetails(AttributeDetails var1);

        default public Builder attributeDetails(Consumer<AttributeDetails.Builder> attributeDetails) {
            return this.attributeDetails((AttributeDetails)((AttributeDetails.Builder)AttributeDetails.builder().applyMutation(attributeDetails)).build());
        }

        public Builder conditions(Conditions var1);

        default public Builder conditions(Consumer<Conditions.Builder> conditions) {
            return this.conditions((Conditions)((Conditions.Builder)Conditions.builder().applyMutation(conditions)).build());
        }

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

