/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.EventStreamDestinationDetails;
import software.amazon.awssdk.services.customerprofiles.model.EventStreamState;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventStreamResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetEventStreamResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetEventStreamResponse.getter(GetEventStreamResponse::domainName)).setter(GetEventStreamResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> EVENT_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventStreamArn").getter(GetEventStreamResponse.getter(GetEventStreamResponse::eventStreamArn)).setter(GetEventStreamResponse.setter(Builder::eventStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStreamArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetEventStreamResponse.getter(GetEventStreamResponse::createdAt)).setter(GetEventStreamResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetEventStreamResponse.getter(GetEventStreamResponse::stateAsString)).setter(GetEventStreamResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> STOPPED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StoppedSince").getter(GetEventStreamResponse.getter(GetEventStreamResponse::stoppedSince)).setter(GetEventStreamResponse.setter(Builder::stoppedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedSince").build()}).build();
    private static final SdkField<EventStreamDestinationDetails> DESTINATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationDetails").getter(GetEventStreamResponse.getter(GetEventStreamResponse::destinationDetails)).setter(GetEventStreamResponse.setter(Builder::destinationDetails)).constructor(EventStreamDestinationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDetails").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetEventStreamResponse.getter(GetEventStreamResponse::tags)).setter(GetEventStreamResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, EVENT_STREAM_ARN_FIELD, CREATED_AT_FIELD, STATE_FIELD, STOPPED_SINCE_FIELD, DESTINATION_DETAILS_FIELD, TAGS_FIELD));
    private final String domainName;
    private final String eventStreamArn;
    private final Instant createdAt;
    private final String state;
    private final Instant stoppedSince;
    private final EventStreamDestinationDetails destinationDetails;
    private final Map<String, String> tags;

    private GetEventStreamResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.eventStreamArn = builder.eventStreamArn;
        this.createdAt = builder.createdAt;
        this.state = builder.state;
        this.stoppedSince = builder.stoppedSince;
        this.destinationDetails = builder.destinationDetails;
        this.tags = builder.tags;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String eventStreamArn() {
        return this.eventStreamArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final EventStreamState state() {
        return EventStreamState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant stoppedSince() {
        return this.stoppedSince;
    }

    public final EventStreamDestinationDetails destinationDetails() {
        return this.destinationDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventStreamResponse)) {
            return false;
        }
        GetEventStreamResponse other = (GetEventStreamResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.eventStreamArn(), other.eventStreamArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stoppedSince(), other.stoppedSince()) && Objects.equals(this.destinationDetails(), other.destinationDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventStreamResponse").add("DomainName", (Object)this.domainName()).add("EventStreamArn", (Object)this.eventStreamArn()).add("CreatedAt", (Object)this.createdAt()).add("State", (Object)this.stateAsString()).add("StoppedSince", (Object)this.stoppedSince()).add("DestinationDetails", (Object)this.destinationDetails()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EventStreamArn": {
                return Optional.ofNullable(clazz.cast(this.eventStreamArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StoppedSince": {
                return Optional.ofNullable(clazz.cast(this.stoppedSince()));
            }
            case "DestinationDetails": {
                return Optional.ofNullable(clazz.cast(this.destinationDetails()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventStreamResponse, T> g) {
        return obj -> g.apply((GetEventStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String eventStreamArn;
        private Instant createdAt;
        private String state;
        private Instant stoppedSince;
        private EventStreamDestinationDetails destinationDetails;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventStreamResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.eventStreamArn(model.eventStreamArn);
            this.createdAt(model.createdAt);
            this.state(model.state);
            this.stoppedSince(model.stoppedSince);
            this.destinationDetails(model.destinationDetails);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEventStreamArn() {
            return this.eventStreamArn;
        }

        public final void setEventStreamArn(String eventStreamArn) {
            this.eventStreamArn = eventStreamArn;
        }

        @Override
        public final Builder eventStreamArn(String eventStreamArn) {
            this.eventStreamArn = eventStreamArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EventStreamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStoppedSince() {
            return this.stoppedSince;
        }

        public final void setStoppedSince(Instant stoppedSince) {
            this.stoppedSince = stoppedSince;
        }

        @Override
        public final Builder stoppedSince(Instant stoppedSince) {
            this.stoppedSince = stoppedSince;
            return this;
        }

        public final EventStreamDestinationDetails.Builder getDestinationDetails() {
            return this.destinationDetails != null ? this.destinationDetails.toBuilder() : null;
        }

        public final void setDestinationDetails(EventStreamDestinationDetails.BuilderImpl destinationDetails) {
            this.destinationDetails = destinationDetails != null ? destinationDetails.build() : null;
        }

        @Override
        public final Builder destinationDetails(EventStreamDestinationDetails destinationDetails) {
            this.destinationDetails = destinationDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetEventStreamResponse build() {
            return new GetEventStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventStreamResponse> {
        public Builder domainName(String var1);

        public Builder eventStreamArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder state(String var1);

        public Builder state(EventStreamState var1);

        public Builder stoppedSince(Instant var1);

        public Builder destinationDetails(EventStreamDestinationDetails var1);

        default public Builder destinationDetails(Consumer<EventStreamDestinationDetails.Builder> destinationDetails) {
            return this.destinationDetails((EventStreamDestinationDetails)((EventStreamDestinationDetails.Builder)EventStreamDestinationDetails.builder().applyMutation(destinationDetails)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

