/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a field in a ProfileObjectType.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectTypeField implements SdkPojo, Serializable, ToCopyableBuilder<ObjectTypeField.Builder, ObjectTypeField> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(ObjectTypeField::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(ObjectTypeField::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(ObjectTypeField::contentTypeAsString)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD,
            CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String target;

    private final String contentType;

    private ObjectTypeField(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * A field of a ProfileObject. For example: _source.FirstName, where “_source” is a ProfileObjectType of a Zendesk
     * user and “FirstName” is a field in that ObjectType.
     * </p>
     * 
     * @return A field of a ProfileObject. For example: _source.FirstName, where “_source” is a ProfileObjectType of a
     *         Zendesk user and “FirstName” is a field in that ObjectType.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The location of the data in the standard ProfileObject model. For example: _profile.Address.PostalCode.
     * </p>
     * 
     * @return The location of the data in the standard ProfileObject model. For example: _profile.Address.PostalCode.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The content type of the field. Used for determining equality when searching.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link FieldContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The content type of the field. Used for determining equality when searching.
     * @see FieldContentType
     */
    public final FieldContentType contentType() {
        return FieldContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The content type of the field. Used for determining equality when searching.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link FieldContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The content type of the field. Used for determining equality when searching.
     * @see FieldContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectTypeField)) {
            return false;
        }
        ObjectTypeField other = (ObjectTypeField) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(target(), other.target())
                && Objects.equals(contentTypeAsString(), other.contentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectTypeField").add("Source", source()).add("Target", target())
                .add("ContentType", contentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectTypeField, T> g) {
        return obj -> g.apply((ObjectTypeField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectTypeField> {
        /**
         * <p>
         * A field of a ProfileObject. For example: _source.FirstName, where “_source” is a ProfileObjectType of a
         * Zendesk user and “FirstName” is a field in that ObjectType.
         * </p>
         * 
         * @param source
         *        A field of a ProfileObject. For example: _source.FirstName, where “_source” is a ProfileObjectType of
         *        a Zendesk user and “FirstName” is a field in that ObjectType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The location of the data in the standard ProfileObject model. For example: _profile.Address.PostalCode.
         * </p>
         * 
         * @param target
         *        The location of the data in the standard ProfileObject model. For example:
         *        _profile.Address.PostalCode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The content type of the field. Used for determining equality when searching.
         * </p>
         * 
         * @param contentType
         *        The content type of the field. Used for determining equality when searching.
         * @see FieldContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The content type of the field. Used for determining equality when searching.
         * </p>
         * 
         * @param contentType
         *        The content type of the field. Used for determining equality when searching.
         * @see FieldContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldContentType
         */
        Builder contentType(FieldContentType contentType);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String target;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectTypeField model) {
            source(model.source);
            target(model.target);
            contentType(model.contentType);
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(FieldContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public ObjectTypeField build() {
            return new ObjectTypeField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
