/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt;

import software.amazon.awssdk.crt.CRT;

public class Log {
    private static final String LOG_DESTINATION_PROPERTY_NAME = "aws.crt.log.destination";
    private static final String LOG_FILE_NAME_PROPERTY_NAME = "aws.crt.log.filename";
    private static final String LOG_LEVEL_PROPERTY_NAME = "aws.crt.log.level";

    public static void log(LogLevel level, LogSubject subject, String message) {
        Log.log(level.getValue(), subject.getValue(), message);
    }

    public static void initLoggingFromSystemProperties() throws IllegalArgumentException {
        String destinationString = System.getProperty(LOG_DESTINATION_PROPERTY_NAME);
        String filenameString = System.getProperty(LOG_FILE_NAME_PROPERTY_NAME);
        String levelString = System.getProperty(LOG_LEVEL_PROPERTY_NAME);
        if (destinationString == null) {
            return;
        }
        LogDestination destination = LogDestination.valueOf(destinationString);
        LogLevel level = LogLevel.Warn;
        if (levelString != null) {
            level = LogLevel.valueOf(levelString);
        }
        switch (destination) {
            case Stdout: {
                Log.initLoggingToStdout(level.getValue());
                break;
            }
            case Stderr: {
                Log.initLoggingToStderr(level.getValue());
                break;
            }
            case File: {
                if (filenameString == null) {
                    return;
                }
                Log.initLoggingToFile(level.getValue(), filenameString);
                break;
            }
        }
    }

    public static void initLoggingToStdout(LogLevel level) {
        Log.initLoggingToStdout(level.getValue());
    }

    public static void initLoggingToStderr(LogLevel level) {
        Log.initLoggingToStderr(level.getValue());
    }

    public static void initLoggingToFile(LogLevel level, String filename) {
        Log.initLoggingToFile(level.getValue(), filename);
    }

    private static native void log(int var0, int var1, String var2);

    private static native void initLoggingToStdout(int var0);

    private static native void initLoggingToStderr(int var0);

    private static native void initLoggingToFile(int var0, String var1);

    static {
        new CRT();
    }

    public static enum LogSubject {
        CommonGeneral(0),
        CommonTaskScheduler(1),
        IoGeneral(1024),
        IoEventLoop(1025),
        IoSocket(1026),
        IoSocketHandler(1027),
        IoTls(1028),
        IoAlpn(1029),
        IoDns(1030),
        IoPki(1031),
        IoChannel(1032),
        IoChannelBootstrap(1033),
        IoFileUtils(1034),
        IoSharedLibrary(1035),
        HttpGeneral(2048),
        HttpConnection(2049),
        HttpServer(2050),
        HttpStream(2051),
        HttpConnectionManager(2052),
        HttpWebsocket(2053),
        HttpWebsocketSetup(2054),
        MqttGeneral(5120),
        MqttClient(5121),
        MqttTopicTree(5122),
        AuthGeneral(6144),
        AuthProfile(6145),
        AuthCredentialsProvider(6146),
        AuthSigning(6147),
        JavaCrtGeneral(9216),
        JavaCrtResource(9217);

        private int value;

        private LogSubject(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LogLevel {
        None(0),
        Fatal(1),
        Error(2),
        Warn(3),
        Info(4),
        Debug(5),
        Trace(6);

        private int level;

        private LogLevel(int value) {
            this.level = value;
        }

        public int getValue() {
            return this.level;
        }
    }

    private static enum LogDestination {
        None,
        Stdout,
        Stderr,
        File;

    }
}

