/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.CrtHttpStreamHandler;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStream;

public class HttpClientConnection
extends CrtResource {
    private final HttpClientConnectionManager manager;

    protected HttpClientConnection(HttpClientConnectionManager manager, long connection) {
        this.acquireNativeHandle(connection);
        this.manager = this.addReferenceTo(manager);
    }

    public CompletableFuture<HttpStream> makeRequest(HttpRequest request, CrtHttpStreamHandler streamHandler) throws CrtRuntimeException {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnection has been closed, can't make requests on it.");
        }
        CompletableFuture<HttpStream> streamFuture = new CompletableFuture<HttpStream>();
        try {
            HttpStream stream = HttpClientConnection.httpClientConnectionMakeRequest(this.getNativeHandle(), request.getMethod(), request.getEncodedPath(), request.getHeaders(), streamHandler);
            if (stream == null || stream.isNull()) {
                streamFuture.completeExceptionally(new RuntimeException("HttpStream creation failed"));
            }
            streamFuture.complete(stream);
        }
        catch (Exception e) {
            streamFuture.completeExceptionally(e);
        }
        return streamFuture;
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            this.manager.releaseConnectionPointer(this.getNativeHandle());
        }
    }

    private static native HttpStream httpClientConnectionMakeRequest(long var0, String var2, String var3, HttpHeader[] var4, CrtHttpStreamHandler var5) throws CrtRuntimeException;
}

