/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;

public final class SocketOptions
extends CrtResource {
    public SocketOptions() throws CrtRuntimeException {
        this.acquire(SocketOptions.socketOptionsNew());
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            SocketOptions.socketOptionsDestroy(this.release());
        }
        super.close();
    }

    void setDomain(SocketDomain domain) {
        SocketOptions.socketOptionsSetDomain(this.native_ptr(), domain.getValue());
    }

    void setType(SocketType type) {
        SocketOptions.socketOptionsSetType(this.native_ptr(), type.getValue());
    }

    void setConnectTimeoutMs(int timeoutMs) {
        SocketOptions.socketOptionsSetConnectTimeoutMs(this.native_ptr(), timeoutMs);
    }

    void setKeepAliveIntervalSeconds(short intervalSeconds) {
        SocketOptions.socketOptionsSetKeepAliveIntervalSec(this.native_ptr(), intervalSeconds);
    }

    void setKeepAliveTimeoutSeconds(short timeoutSeconds) {
        SocketOptions.socketOptionsSetKeepAliveTimeoutSec(this.native_ptr(), timeoutSeconds);
    }

    private static native long socketOptionsNew() throws CrtRuntimeException;

    private static native void socketOptionsDestroy(long var0);

    private static native void socketOptionsSetDomain(long var0, int var2);

    private static native void socketOptionsSetType(long var0, int var2);

    private static native void socketOptionsSetConnectTimeoutMs(long var0, int var2);

    private static native void socketOptionsSetKeepAliveIntervalSec(long var0, short var2);

    private static native void socketOptionsSetKeepAliveTimeoutSec(long var0, short var2);

    public static enum SocketType {
        STREAM(0),
        DGRAM(1);

        private int type;

        private SocketType(int val) {
            this.type = val;
        }

        int getValue() {
            return this.type;
        }
    }

    public static enum SocketDomain {
        IPv4(0),
        IPv6(1),
        LOCAL(2);

        private int domain;

        private SocketDomain(int val) {
            this.domain = val;
        }

        int getValue() {
            return this.domain;
        }
    }
}

