/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.utils;

import java.nio.ByteBuffer;

public class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static ByteBuffer deepCopy(ByteBuffer input) {
        ByteBuffer deepCopy = ByteBuffer.allocate(input.remaining());
        deepCopy.put(input);
        deepCopy.flip();
        return deepCopy;
    }

    public static int transferData(ByteBuffer in, ByteBuffer out) {
        int amtToTransfer = Math.min(in.remaining(), out.remaining());
        ByteBuffer shallowCopy = in.duplicate();
        shallowCopy.limit(shallowCopy.position() + amtToTransfer);
        out.put(shallowCopy);
        in.position(in.position() + amtToTransfer);
        return amtToTransfer;
    }
}

