/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.io.TlsCipherPreference;

public final class TlsContextOptions
extends CrtResource {
    private TlsVersions tlsVersion = TlsVersions.TLS_VER_SYS_DEFAULTS;
    private TlsCipherPreference tlsCipherPreference = TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT;

    public TlsContextOptions() throws CrtRuntimeException {
        this.acquire(TlsContextOptions.tlsContextOptionsNew());
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            TlsContextOptions.tlsContextOptionsDestroy(this.release());
        }
        super.close();
    }

    public void setMinimumTlsVersion(TlsVersions version) {
        if (this.tlsCipherPreference != TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT && version != TlsVersions.TLS_VER_SYS_DEFAULTS) {
            throw new IllegalArgumentException("Currently only setMinimumTlsVersion() or setCipherPreference() may be used, not both.");
        }
        this.tlsVersion = version;
        TlsContextOptions.tlsContextOptionsSetMinimumTlsVersion(this.native_ptr(), version.getValue());
    }

    public void setAlpnList(String alpn) {
        TlsContextOptions.tlsContextOptionsSetAlpn(this.native_ptr(), alpn);
    }

    public void setCipherPreference(TlsCipherPreference cipherPref) {
        if (!TlsContextOptions.isCipherPreferenceSupported(cipherPref)) {
            throw new IllegalArgumentException("TlsCipherPreference is not supported on this platform: " + cipherPref.name());
        }
        if (this.tlsVersion != TlsVersions.TLS_VER_SYS_DEFAULTS && cipherPref != TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT) {
            throw new IllegalArgumentException("Currently only setMinimumTlsVersion() or setCipherPreference() may be used, not both.");
        }
        this.tlsCipherPreference = cipherPref;
        TlsContextOptions.tlsContextOptionsSetCipherPreference(this.native_ptr(), cipherPref.getValue());
    }

    public void initMTLSFromPath(String certificatePath, String privateKeyPath) {
        TlsContextOptions.tlsContextOptionsInitMTLSFromPath(this.native_ptr(), certificatePath, privateKeyPath);
    }

    public void initMTLSPkcs12(String pkcs12Path, String pkcs12Password) {
        TlsContextOptions.tlsContextOptionsInitMTLSPkcs12FromPath(this.native_ptr(), pkcs12Path, pkcs12Password);
    }

    public void setVerifyPeer(boolean verify) {
        TlsContextOptions.tlsContextOptionsSetVerifyPeer(this.native_ptr(), verify);
    }

    public static boolean isAlpnSupported() {
        return TlsContextOptions.tlsContextOptionsIsAlpnAvailable();
    }

    public static boolean isCipherPreferenceSupported(TlsCipherPreference cipherPref) {
        return TlsContextOptions.tlsContextOptionsIsCipherPreferenceSupported(cipherPref.getValue());
    }

    public void overrideDefaultTrustStore(String caPath, String caFile) {
        TlsContextOptions.tlsContextOptionsOverrideDefaultTrustStoreFromPath(this.native_ptr(), caFile, caPath);
    }

    public static TlsContextOptions createDefaultClient() throws CrtRuntimeException {
        return new TlsContextOptions();
    }

    public static TlsContextOptions createWithMTLS(String certificatePath, String privateKeyPath) throws CrtRuntimeException {
        TlsContextOptions options = new TlsContextOptions();
        options.initMTLSFromPath(certificatePath, privateKeyPath);
        return options;
    }

    public static TlsContextOptions createWithMTLSPkcs12(String pkcs12Path, String pkcs12Password) throws CrtRuntimeException {
        TlsContextOptions options = new TlsContextOptions();
        options.initMTLSPkcs12(pkcs12Path, pkcs12Password);
        return options;
    }

    public TlsContextOptions withCipherPreference(TlsCipherPreference cipherPref) {
        this.setCipherPreference(cipherPref);
        return this;
    }

    public TlsContextOptions withMinimumTlsVersion(TlsVersions version) {
        this.setMinimumTlsVersion(version);
        return this;
    }

    public TlsContextOptions withAlpnList(String alpnList) {
        this.setAlpnList(alpnList);
        return this;
    }

    private static native long tlsContextOptionsNew() throws CrtRuntimeException;

    private static native void tlsContextOptionsDestroy(long var0);

    private static native void tlsContextOptionsSetMinimumTlsVersion(long var0, int var2);

    private static native void tlsContextOptionsOverrideDefaultTrustStoreFromPath(long var0, String var2, String var3);

    private static native void tlsContextOptionsSetAlpn(long var0, String var2);

    private static native void tlsContextOptionsSetCipherPreference(long var0, int var2);

    private static native void tlsContextOptionsInitMTLSFromPath(long var0, String var2, String var3);

    private static native void tlsContextOptionsInitMTLSPkcs12FromPath(long var0, String var2, String var3);

    private static native void tlsContextOptionsSetVerifyPeer(long var0, boolean var2);

    private static native boolean tlsContextOptionsIsAlpnAvailable();

    private static native boolean tlsContextOptionsIsCipherPreferenceSupported(int var0);

    public static enum TlsVersions {
        SSLv3(0),
        TLSv1(1),
        TLSv1_1(2),
        TLSv1_2(3),
        TLSv1_3(4),
        TLS_VER_SYS_DEFAULTS(128);

        private int version;

        private TlsVersions(int val) {
            this.version = val;
        }

        int getValue() {
            return this.version;
        }
    }
}

