/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.CrtHttpStreamHandler;
import software.amazon.awssdk.crt.http.HttpConnectionPoolManager;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestOptions;
import software.amazon.awssdk.crt.http.HttpStream;

public class HttpConnection
extends CrtResource {
    private final HttpConnectionPoolManager manager;

    protected HttpConnection(HttpConnectionPoolManager manager, long connection) {
        this.manager = manager;
        this.acquire(connection);
    }

    public HttpStream makeRequest(HttpRequest request, HttpRequestOptions reqOptions, CrtHttpStreamHandler streamHandler) throws CrtRuntimeException {
        if (this.isNull()) {
            throw new IllegalStateException("HttpConnection has been closed, can't make requests on it.");
        }
        if (reqOptions.getBodyBufferSize() > this.manager.getWindowSize()) {
            throw new IllegalArgumentException("Response Body Buffer can't be > than Window Size");
        }
        HttpStream stream = HttpConnection.httpConnectionMakeRequest(this.native_ptr(), reqOptions.getBodyBufferSize(), request.getMethod(), request.getEncodedPath(), request.getHeaders(), streamHandler);
        if (stream == null || stream.isNull()) {
            throw new IllegalStateException("HttpStream is null");
        }
        return stream;
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            this.manager.releaseConnectionPointer(this.release());
            super.close();
        }
    }

    private static native HttpStream httpConnectionMakeRequest(long var0, int var2, String var3, String var4, HttpHeader[] var5, CrtHttpStreamHandler var6) throws CrtRuntimeException;
}

