/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.crt.CRT;

public class CrtResource
implements AutoCloseable {
    private static final ConcurrentHashMap<Long, String> NATIVE_RESOURCES = new ConcurrentHashMap();
    private static final long NULL = 0L;
    private final LinkedList<CrtResource> ownedSubResources = new LinkedList();
    private long ptr;

    public static int getAllocatedNativeResourceCount() {
        return NATIVE_RESOURCES.size();
    }

    public static Collection<String> getAllocatedNativeResources() {
        return Collections.unmodifiableCollection(NATIVE_RESOURCES.values());
    }

    public <T extends CrtResource> T own(T subresource) {
        if (!this.isNull()) {
            throw new IllegalStateException("Parent Resource already created and acquired, can't add sub-resources after the fact.");
        }
        this.ownedSubResources.push(subresource);
        return subresource;
    }

    protected void acquire(long _ptr) {
        if (!this.isNull()) {
            throw new IllegalStateException("Can't acquire >1 Native Pointer");
        }
        String canonicalName = this.getClass().getCanonicalName();
        if (_ptr == 0L) {
            throw new IllegalStateException("Can't acquire NULL Pointer: " + canonicalName);
        }
        String lastValue = NATIVE_RESOURCES.put(_ptr, canonicalName);
        if (lastValue != null) {
            throw new IllegalStateException("Acquired two CrtResources to the same Native Resource! Class: " + lastValue);
        }
        this.ptr = _ptr;
    }

    protected long release() {
        if (this.isNull()) {
            throw new IllegalStateException("Already Released Resource!");
        }
        NATIVE_RESOURCES.remove(this.ptr);
        long addr = this.ptr;
        this.ptr = 0L;
        return addr;
    }

    public long native_ptr() {
        return this.ptr;
    }

    public boolean isNull() {
        return this.ptr == 0L;
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            throw new IllegalStateException("Closing sub-resources before releasing parent Resource may cause use-after-free bugs!");
        }
        while (this.ownedSubResources.size() > 0) {
            CrtResource r = this.ownedSubResources.pop();
            r.close();
        }
    }

    static {
        new CRT();
    }
}

