/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;

public final class TlsContextOptions
extends CrtResource {
    public TlsContextOptions() throws CrtRuntimeException {
        this.acquire(TlsContextOptions.tlsContextOptionsNew());
    }

    @Override
    public void close() {
        if (!this.isNull()) {
            TlsContextOptions.tlsContextOptionsDestroy(this.release());
        }
        super.close();
    }

    public void setMinimumTlsVersion(TlsVersions version) {
        TlsContextOptions.tlsContextOptionsSetMinimumTlsVersion(this.native_ptr(), version.getValue());
    }

    public void setAlpnList(String alpn) {
        TlsContextOptions.tlsContextOptionsSetAlpn(this.native_ptr(), alpn);
    }

    public void initMTLSFromPath(String certificatePath, String privateKeyPath) {
        TlsContextOptions.tlsContextOptionsInitMTLSFromPath(this.native_ptr(), certificatePath, privateKeyPath);
    }

    public void initMTLSPkcs12(String pkcs12Path, String pkcs12Password) {
        TlsContextOptions.tlsContextOptionsInitMTLSPkcs12FromPath(this.native_ptr(), pkcs12Path, pkcs12Password);
    }

    public void setVerifyPeer(boolean verify) {
        TlsContextOptions.tlsContextOptionsSetVerifyPeer(this.native_ptr(), verify);
    }

    public static boolean isAlpnSupported() {
        return TlsContextOptions.tlsContextOptionsIsAlpnAvailable();
    }

    public void overrideDefaultTrustStore(String caPath, String caFile) {
        TlsContextOptions.tlsContextOptionsOverrideDefaultTrustStoreFromPath(this.native_ptr(), caFile, caPath);
    }

    public static TlsContextOptions createDefaultClient() throws CrtRuntimeException {
        return new TlsContextOptions();
    }

    public static TlsContextOptions createWithMTLS(String certificatePath, String privateKeyPath) throws CrtRuntimeException {
        TlsContextOptions options = new TlsContextOptions();
        options.initMTLSFromPath(certificatePath, privateKeyPath);
        return options;
    }

    public static TlsContextOptions createWithMTLSPkcs12(String pkcs12Path, String pkcs12Password) throws CrtRuntimeException {
        TlsContextOptions options = new TlsContextOptions();
        options.initMTLSPkcs12(pkcs12Path, pkcs12Password);
        return options;
    }

    private static native long tlsContextOptionsNew() throws CrtRuntimeException;

    private static native void tlsContextOptionsDestroy(long var0);

    private static native void tlsContextOptionsSetMinimumTlsVersion(long var0, int var2);

    private static native void tlsContextOptionsOverrideDefaultTrustStoreFromPath(long var0, String var2, String var3);

    private static native void tlsContextOptionsSetAlpn(long var0, String var2);

    private static native void tlsContextOptionsInitMTLSFromPath(long var0, String var2, String var3);

    private static native void tlsContextOptionsInitMTLSPkcs12FromPath(long var0, String var2, String var3);

    private static native void tlsContextOptionsSetVerifyPeer(long var0, boolean var2);

    private static native boolean tlsContextOptionsIsAlpnAvailable();

    public static enum TlsVersions {
        SSLv3(0),
        TLSv1(1),
        TLSv1_1(2),
        TLSv1_2(3),
        TLSv1_3(4),
        TLS_VER_SYS_DEFAULTS(128);

        private int version;

        private TlsVersions(int val) {
            this.version = val;
        }

        int getValue() {
            return this.version;
        }
    }
}

