/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt;

import java.io.Closeable;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.EventLoopGroup;
import software.amazon.awssdk.crt.io.TlsContext;

public class MqttClient
extends CrtResource
implements Closeable {
    private final ClientBootstrap bootstrap;
    private final TlsContext tlsContext;

    public MqttClient() throws CrtRuntimeException {
        this(new ClientBootstrap(new EventLoopGroup(1)), null);
    }

    public MqttClient(ClientBootstrap clientBootstrap) throws CrtRuntimeException {
        this(clientBootstrap, null);
    }

    public MqttClient(ClientBootstrap clientBootstrap, TlsContext tlsContext) throws CrtRuntimeException {
        this.bootstrap = clientBootstrap;
        this.tlsContext = tlsContext;
        this.acquire(MqttClient.mqttClientNew(this.bootstrap.native_ptr()));
    }

    @Override
    public void close() {
        if (this.native_ptr() != 0L) {
            MqttClient.mqttClientDestroy(this.release());
        }
    }

    public TlsContext tlsContext() {
        return this.tlsContext;
    }

    private static native long mqttClientNew(long var0) throws CrtRuntimeException;

    private static native void mqttClientDestroy(long var0);
}

