/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.io.Closeable;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;

public final class TlsContextOptions
extends CrtResource
implements Closeable {
    public TlsContextOptions() throws CrtRuntimeException {
        this.acquire(TlsContextOptions.tlsContextOptionsNew());
    }

    @Override
    public void close() {
        if (this.native_ptr() != 0L) {
            TlsContextOptions.tlsContextOptionsDestroy(this.release());
        }
    }

    public void setMinimumTlsVersion(TlsVersions version) {
        TlsContextOptions.tlsContextOptionsSetMinimumTlsVersion(this.native_ptr(), version.getValue());
    }

    public void setCaFile(String caFile) {
        TlsContextOptions.tlsContextOptionsSetCaFile(this.native_ptr(), caFile);
    }

    public void setCaPath(String caPath) {
        TlsContextOptions.tlsContextOptionsSetCaPath(this.native_ptr(), caPath);
    }

    public void setAlpnList(String alpn) {
        TlsContextOptions.tlsContextOptionsSetAlpn(this.native_ptr(), alpn);
    }

    public void setCertificatePath(String certificatePath) {
        TlsContextOptions.tlsContextOptionsSetCertificatePath(this.native_ptr(), certificatePath);
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        TlsContextOptions.tlsContextOptionsSetPrivateKeyPath(this.native_ptr(), privateKeyPath);
    }

    public void setPkcs12Path(String pkcs12Path) {
        TlsContextOptions.tlsContextOptionsSetPkcs12Path(this.native_ptr(), pkcs12Path);
    }

    public void setPkcs12Password(String pkcs12Password) {
        TlsContextOptions.tlsContextOptionsSetPkcs12Password(this.native_ptr(), pkcs12Password);
    }

    public void setVerifyPeer(boolean verify) {
        TlsContextOptions.tlsContextOptionsSetVerifyPeer(this.native_ptr(), verify);
    }

    public static boolean isAlpnSupported() {
        return TlsContextOptions.tlsContextOptionsIsAlpnAvailable();
    }

    public void overrideDefaultTrustStore(String caPath, String caFile) {
        this.setCaPath(caPath);
        this.setCaFile(caFile);
    }

    public static TlsContextOptions createDefaultClient() throws CrtRuntimeException {
        return new TlsContextOptions();
    }

    public static TlsContextOptions createWithMTLS(String certificatePath, String privateKeyPath) throws CrtRuntimeException {
        TlsContextOptions options = new TlsContextOptions();
        options.setCertificatePath(certificatePath);
        options.setPrivateKeyPath(privateKeyPath);
        return options;
    }

    public static TlsContextOptions createWithMTLSPkcs12(String pkcs12Path, String pkcs12Password) throws CrtRuntimeException {
        TlsContextOptions options = new TlsContextOptions();
        options.setPkcs12Path(pkcs12Path);
        options.setPkcs12Password(pkcs12Password);
        return options;
    }

    private static native long tlsContextOptionsNew() throws CrtRuntimeException;

    private static native void tlsContextOptionsDestroy(long var0);

    private static native void tlsContextOptionsSetMinimumTlsVersion(long var0, int var2);

    private static native void tlsContextOptionsSetCaFile(long var0, String var2);

    private static native void tlsContextOptionsSetCaPath(long var0, String var2);

    private static native void tlsContextOptionsSetAlpn(long var0, String var2);

    private static native void tlsContextOptionsSetCertificatePath(long var0, String var2);

    private static native void tlsContextOptionsSetPrivateKeyPath(long var0, String var2);

    private static native void tlsContextOptionsSetPkcs12Path(long var0, String var2);

    private static native void tlsContextOptionsSetPkcs12Password(long var0, String var2);

    private static native void tlsContextOptionsSetVerifyPeer(long var0, boolean var2);

    private static native boolean tlsContextOptionsIsAlpnAvailable();

    public static enum TlsVersions {
        SSLv3(0),
        TLSv1(1),
        TLSv1_1(2),
        TLSv1_2(3),
        TLSv1_3(4),
        TLS_VER_SYS_DEFAULTS(128);

        private int version;

        private TlsVersions(int val) {
            this.version = val;
        }

        int getValue() {
            return this.version;
        }
    }
}

