/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubAsyncClient;
import software.amazon.awssdk.services.costoptimizationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.costoptimizationhub.model.EfficiencyMetricsByGroup;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEfficiencyMetricsRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEfficiencyMetricsResponse;

public class ListEfficiencyMetricsPublisher
implements SdkPublisher<ListEfficiencyMetricsResponse> {
    private final CostOptimizationHubAsyncClient client;
    private final ListEfficiencyMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEfficiencyMetricsPublisher(CostOptimizationHubAsyncClient client, ListEfficiencyMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEfficiencyMetricsPublisher(CostOptimizationHubAsyncClient client, ListEfficiencyMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEfficiencyMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEfficiencyMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EfficiencyMetricsByGroup> efficiencyMetricsByGroup() {
        Function<ListEfficiencyMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.efficiencyMetricsByGroup() != null) {
                return response.efficiencyMetricsByGroup().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEfficiencyMetricsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEfficiencyMetricsResponseFetcher
    implements AsyncPageFetcher<ListEfficiencyMetricsResponse> {
        private ListEfficiencyMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListEfficiencyMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEfficiencyMetricsResponse> nextPage(ListEfficiencyMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListEfficiencyMetricsPublisher.this.client.listEfficiencyMetrics(ListEfficiencyMetricsPublisher.this.firstRequest);
            }
            return ListEfficiencyMetricsPublisher.this.client.listEfficiencyMetrics((ListEfficiencyMetricsRequest)((Object)ListEfficiencyMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

