/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.CostOptimizationHubRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.GranularityType;
import software.amazon.awssdk.services.costoptimizationhub.model.OrderBy;
import software.amazon.awssdk.services.costoptimizationhub.model.TimePeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEfficiencyMetricsRequest
extends CostOptimizationHubRequest
implements ToCopyableBuilder<Builder, ListEfficiencyMetricsRequest> {
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupBy").getter(ListEfficiencyMetricsRequest.getter(ListEfficiencyMetricsRequest::groupBy)).setter(ListEfficiencyMetricsRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("granularity").getter(ListEfficiencyMetricsRequest.getter(ListEfficiencyMetricsRequest::granularityAsString)).setter(ListEfficiencyMetricsRequest.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("granularity").build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timePeriod").getter(ListEfficiencyMetricsRequest.getter(ListEfficiencyMetricsRequest::timePeriod)).setter(ListEfficiencyMetricsRequest.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePeriod").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListEfficiencyMetricsRequest.getter(ListEfficiencyMetricsRequest::maxResults)).setter(ListEfficiencyMetricsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<OrderBy> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orderBy").getter(ListEfficiencyMetricsRequest.getter(ListEfficiencyMetricsRequest::orderBy)).setter(ListEfficiencyMetricsRequest.setter(Builder::orderBy)).constructor(OrderBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEfficiencyMetricsRequest.getter(ListEfficiencyMetricsRequest::nextToken)).setter(ListEfficiencyMetricsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD, GRANULARITY_FIELD, TIME_PERIOD_FIELD, MAX_RESULTS_FIELD, ORDER_BY_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEfficiencyMetricsRequest.memberNameToFieldInitializer();
    private final String groupBy;
    private final String granularity;
    private final TimePeriod timePeriod;
    private final Integer maxResults;
    private final OrderBy orderBy;
    private final String nextToken;

    private ListEfficiencyMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.groupBy = builder.groupBy;
        this.granularity = builder.granularity;
        this.timePeriod = builder.timePeriod;
        this.maxResults = builder.maxResults;
        this.orderBy = builder.orderBy;
        this.nextToken = builder.nextToken;
    }

    public final String groupBy() {
        return this.groupBy;
    }

    public final GranularityType granularity() {
        return GranularityType.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final OrderBy orderBy() {
        return this.orderBy;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEfficiencyMetricsRequest)) {
            return false;
        }
        ListEfficiencyMetricsRequest other = (ListEfficiencyMetricsRequest)((Object)obj);
        return Objects.equals(this.groupBy(), other.groupBy()) && Objects.equals(this.granularityAsString(), other.granularityAsString()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.orderBy(), other.orderBy()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEfficiencyMetricsRequest").add("GroupBy", (Object)this.groupBy()).add("Granularity", (Object)this.granularityAsString()).add("TimePeriod", (Object)this.timePeriod()).add("MaxResults", (Object)this.maxResults()).add("OrderBy", (Object)this.orderBy()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "timePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "orderBy": {
                return Optional.ofNullable(clazz.cast(this.orderBy()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupBy", GROUP_BY_FIELD);
        map.put("granularity", GRANULARITY_FIELD);
        map.put("timePeriod", TIME_PERIOD_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("orderBy", ORDER_BY_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEfficiencyMetricsRequest, T> g) {
        return obj -> g.apply((ListEfficiencyMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostOptimizationHubRequest.BuilderImpl
    implements Builder {
        private String groupBy;
        private String granularity;
        private TimePeriod timePeriod;
        private Integer maxResults;
        private OrderBy orderBy;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEfficiencyMetricsRequest model) {
            super(model);
            this.groupBy(model.groupBy);
            this.granularity(model.granularity);
            this.timePeriod(model.timePeriod);
            this.maxResults(model.maxResults);
            this.orderBy(model.orderBy);
            this.nextToken(model.nextToken);
        }

        public final String getGroupBy() {
            return this.groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(GranularityType granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final OrderBy.Builder getOrderBy() {
            return this.orderBy != null ? this.orderBy.toBuilder() : null;
        }

        public final void setOrderBy(OrderBy.BuilderImpl orderBy) {
            this.orderBy = orderBy != null ? orderBy.build() : null;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEfficiencyMetricsRequest build() {
            return new ListEfficiencyMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostOptimizationHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEfficiencyMetricsRequest> {
        public Builder groupBy(String var1);

        public Builder granularity(String var1);

        public Builder granularity(GranularityType var1);

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder orderBy(OrderBy var1);

        default public Builder orderBy(Consumer<OrderBy.Builder> orderBy) {
            return this.orderBy((OrderBy)((OrderBy.Builder)OrderBy.builder().applyMutation(orderBy)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

