/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Term {
    ONE_YEAR("OneYear"),
    THREE_YEARS("ThreeYears"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Term> VALUE_MAP;
    private final String value;

    private Term(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Term fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Term> knownValues() {
        EnumSet<Term> knownValues = EnumSet.allOf(Term.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Term.class, Term::toString);
    }
}

