/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.EstimatedDiscounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcePricing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcePricing> {
    private static final SdkField<Double> ESTIMATED_COST_BEFORE_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedCostBeforeDiscounts").getter(ResourcePricing.getter(ResourcePricing::estimatedCostBeforeDiscounts)).setter(ResourcePricing.setter(Builder::estimatedCostBeforeDiscounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCostBeforeDiscounts").build()}).build();
    private static final SdkField<Double> ESTIMATED_NET_UNUSED_AMORTIZED_COMMITMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedNetUnusedAmortizedCommitments").getter(ResourcePricing.getter(ResourcePricing::estimatedNetUnusedAmortizedCommitments)).setter(ResourcePricing.setter(Builder::estimatedNetUnusedAmortizedCommitments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedNetUnusedAmortizedCommitments").build()}).build();
    private static final SdkField<EstimatedDiscounts> ESTIMATED_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("estimatedDiscounts").getter(ResourcePricing.getter(ResourcePricing::estimatedDiscounts)).setter(ResourcePricing.setter(Builder::estimatedDiscounts)).constructor(EstimatedDiscounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedDiscounts").build()}).build();
    private static final SdkField<Double> ESTIMATED_COST_AFTER_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedCostAfterDiscounts").getter(ResourcePricing.getter(ResourcePricing::estimatedCostAfterDiscounts)).setter(ResourcePricing.setter(Builder::estimatedCostAfterDiscounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCostAfterDiscounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_COST_BEFORE_DISCOUNTS_FIELD, ESTIMATED_NET_UNUSED_AMORTIZED_COMMITMENTS_FIELD, ESTIMATED_DISCOUNTS_FIELD, ESTIMATED_COST_AFTER_DISCOUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double estimatedCostBeforeDiscounts;
    private final Double estimatedNetUnusedAmortizedCommitments;
    private final EstimatedDiscounts estimatedDiscounts;
    private final Double estimatedCostAfterDiscounts;

    private ResourcePricing(BuilderImpl builder) {
        this.estimatedCostBeforeDiscounts = builder.estimatedCostBeforeDiscounts;
        this.estimatedNetUnusedAmortizedCommitments = builder.estimatedNetUnusedAmortizedCommitments;
        this.estimatedDiscounts = builder.estimatedDiscounts;
        this.estimatedCostAfterDiscounts = builder.estimatedCostAfterDiscounts;
    }

    public final Double estimatedCostBeforeDiscounts() {
        return this.estimatedCostBeforeDiscounts;
    }

    public final Double estimatedNetUnusedAmortizedCommitments() {
        return this.estimatedNetUnusedAmortizedCommitments;
    }

    public final EstimatedDiscounts estimatedDiscounts() {
        return this.estimatedDiscounts;
    }

    public final Double estimatedCostAfterDiscounts() {
        return this.estimatedCostAfterDiscounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCostBeforeDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedNetUnusedAmortizedCommitments());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCostAfterDiscounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePricing)) {
            return false;
        }
        ResourcePricing other = (ResourcePricing)obj;
        return Objects.equals(this.estimatedCostBeforeDiscounts(), other.estimatedCostBeforeDiscounts()) && Objects.equals(this.estimatedNetUnusedAmortizedCommitments(), other.estimatedNetUnusedAmortizedCommitments()) && Objects.equals(this.estimatedDiscounts(), other.estimatedDiscounts()) && Objects.equals(this.estimatedCostAfterDiscounts(), other.estimatedCostAfterDiscounts());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcePricing").add("EstimatedCostBeforeDiscounts", (Object)this.estimatedCostBeforeDiscounts()).add("EstimatedNetUnusedAmortizedCommitments", (Object)this.estimatedNetUnusedAmortizedCommitments()).add("EstimatedDiscounts", (Object)this.estimatedDiscounts()).add("EstimatedCostAfterDiscounts", (Object)this.estimatedCostAfterDiscounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "estimatedCostBeforeDiscounts": {
                return Optional.ofNullable(clazz.cast(this.estimatedCostBeforeDiscounts()));
            }
            case "estimatedNetUnusedAmortizedCommitments": {
                return Optional.ofNullable(clazz.cast(this.estimatedNetUnusedAmortizedCommitments()));
            }
            case "estimatedDiscounts": {
                return Optional.ofNullable(clazz.cast(this.estimatedDiscounts()));
            }
            case "estimatedCostAfterDiscounts": {
                return Optional.ofNullable(clazz.cast(this.estimatedCostAfterDiscounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePricing, T> g) {
        return obj -> g.apply((ResourcePricing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double estimatedCostBeforeDiscounts;
        private Double estimatedNetUnusedAmortizedCommitments;
        private EstimatedDiscounts estimatedDiscounts;
        private Double estimatedCostAfterDiscounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePricing model) {
            this.estimatedCostBeforeDiscounts(model.estimatedCostBeforeDiscounts);
            this.estimatedNetUnusedAmortizedCommitments(model.estimatedNetUnusedAmortizedCommitments);
            this.estimatedDiscounts(model.estimatedDiscounts);
            this.estimatedCostAfterDiscounts(model.estimatedCostAfterDiscounts);
        }

        public final Double getEstimatedCostBeforeDiscounts() {
            return this.estimatedCostBeforeDiscounts;
        }

        public final void setEstimatedCostBeforeDiscounts(Double estimatedCostBeforeDiscounts) {
            this.estimatedCostBeforeDiscounts = estimatedCostBeforeDiscounts;
        }

        @Override
        public final Builder estimatedCostBeforeDiscounts(Double estimatedCostBeforeDiscounts) {
            this.estimatedCostBeforeDiscounts = estimatedCostBeforeDiscounts;
            return this;
        }

        public final Double getEstimatedNetUnusedAmortizedCommitments() {
            return this.estimatedNetUnusedAmortizedCommitments;
        }

        public final void setEstimatedNetUnusedAmortizedCommitments(Double estimatedNetUnusedAmortizedCommitments) {
            this.estimatedNetUnusedAmortizedCommitments = estimatedNetUnusedAmortizedCommitments;
        }

        @Override
        public final Builder estimatedNetUnusedAmortizedCommitments(Double estimatedNetUnusedAmortizedCommitments) {
            this.estimatedNetUnusedAmortizedCommitments = estimatedNetUnusedAmortizedCommitments;
            return this;
        }

        public final EstimatedDiscounts.Builder getEstimatedDiscounts() {
            return this.estimatedDiscounts != null ? this.estimatedDiscounts.toBuilder() : null;
        }

        public final void setEstimatedDiscounts(EstimatedDiscounts.BuilderImpl estimatedDiscounts) {
            this.estimatedDiscounts = estimatedDiscounts != null ? estimatedDiscounts.build() : null;
        }

        @Override
        public final Builder estimatedDiscounts(EstimatedDiscounts estimatedDiscounts) {
            this.estimatedDiscounts = estimatedDiscounts;
            return this;
        }

        public final Double getEstimatedCostAfterDiscounts() {
            return this.estimatedCostAfterDiscounts;
        }

        public final void setEstimatedCostAfterDiscounts(Double estimatedCostAfterDiscounts) {
            this.estimatedCostAfterDiscounts = estimatedCostAfterDiscounts;
        }

        @Override
        public final Builder estimatedCostAfterDiscounts(Double estimatedCostAfterDiscounts) {
            this.estimatedCostAfterDiscounts = estimatedCostAfterDiscounts;
            return this;
        }

        public ResourcePricing build() {
            return new ResourcePricing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcePricing> {
        public Builder estimatedCostBeforeDiscounts(Double var1);

        public Builder estimatedNetUnusedAmortizedCommitments(Double var1);

        public Builder estimatedDiscounts(EstimatedDiscounts var1);

        default public Builder estimatedDiscounts(Consumer<EstimatedDiscounts.Builder> estimatedDiscounts) {
            return this.estimatedDiscounts((EstimatedDiscounts)((EstimatedDiscounts.Builder)EstimatedDiscounts.builder().applyMutation(estimatedDiscounts)).build());
        }

        public Builder estimatedCostAfterDiscounts(Double var1);
    }
}

