/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockStoragePerformanceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlockStoragePerformanceConfiguration> {
    private static final SdkField<Double> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("iops").getter(BlockStoragePerformanceConfiguration.getter(BlockStoragePerformanceConfiguration::iops)).setter(BlockStoragePerformanceConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()}).build();
    private static final SdkField<Double> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("throughput").getter(BlockStoragePerformanceConfiguration.getter(BlockStoragePerformanceConfiguration::throughput)).setter(BlockStoragePerformanceConfiguration.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, THROUGHPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double iops;
    private final Double throughput;

    private BlockStoragePerformanceConfiguration(BuilderImpl builder) {
        this.iops = builder.iops;
        this.throughput = builder.throughput;
    }

    public final Double iops() {
        return this.iops;
    }

    public final Double throughput() {
        return this.throughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockStoragePerformanceConfiguration)) {
            return false;
        }
        BlockStoragePerformanceConfiguration other = (BlockStoragePerformanceConfiguration)obj;
        return Objects.equals(this.iops(), other.iops()) && Objects.equals(this.throughput(), other.throughput());
    }

    public final String toString() {
        return ToString.builder((String)"BlockStoragePerformanceConfiguration").add("Iops", (Object)this.iops()).add("Throughput", (Object)this.throughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockStoragePerformanceConfiguration, T> g) {
        return obj -> g.apply((BlockStoragePerformanceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double iops;
        private Double throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockStoragePerformanceConfiguration model) {
            this.iops(model.iops);
            this.throughput(model.throughput);
        }

        public final Double getIops() {
            return this.iops;
        }

        public final void setIops(Double iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Double iops) {
            this.iops = iops;
            return this;
        }

        public final Double getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Double throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Double throughput) {
            this.throughput = throughput;
            return this;
        }

        public BlockStoragePerformanceConfiguration build() {
            return new BlockStoragePerformanceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlockStoragePerformanceConfiguration> {
        public Builder iops(Double var1);

        public Builder throughput(Double var1);
    }
}

