/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costoptimizationhub.model.CostOptimizationHubResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.RecommendationSummariesListCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.RecommendationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendationSummariesResponse
extends CostOptimizationHubResponse
implements ToCopyableBuilder<Builder, ListRecommendationSummariesResponse> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currencyCode").getter(ListRecommendationSummariesResponse.getter(ListRecommendationSummariesResponse::currencyCode)).setter(ListRecommendationSummariesResponse.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<Double> ESTIMATED_TOTAL_DEDUPED_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedTotalDedupedSavings").getter(ListRecommendationSummariesResponse.getter(ListRecommendationSummariesResponse::estimatedTotalDedupedSavings)).setter(ListRecommendationSummariesResponse.setter(Builder::estimatedTotalDedupedSavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedTotalDedupedSavings").build()}).build();
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupBy").getter(ListRecommendationSummariesResponse.getter(ListRecommendationSummariesResponse::groupBy)).setter(ListRecommendationSummariesResponse.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()}).build();
    private static final SdkField<List<RecommendationSummary>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(ListRecommendationSummariesResponse.getter(ListRecommendationSummariesResponse::items)).setter(ListRecommendationSummariesResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecommendationSummariesResponse.getter(ListRecommendationSummariesResponse::nextToken)).setter(ListRecommendationSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, ESTIMATED_TOTAL_DEDUPED_SAVINGS_FIELD, GROUP_BY_FIELD, ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final String currencyCode;
    private final Double estimatedTotalDedupedSavings;
    private final String groupBy;
    private final List<RecommendationSummary> items;
    private final String nextToken;

    private ListRecommendationSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.currencyCode = builder.currencyCode;
        this.estimatedTotalDedupedSavings = builder.estimatedTotalDedupedSavings;
        this.groupBy = builder.groupBy;
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Double estimatedTotalDedupedSavings() {
        return this.estimatedTotalDedupedSavings;
    }

    public final String groupBy() {
        return this.groupBy;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<RecommendationSummary> items() {
        return this.items;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTotalDedupedSavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationSummariesResponse)) {
            return false;
        }
        ListRecommendationSummariesResponse other = (ListRecommendationSummariesResponse)((Object)obj);
        return Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.estimatedTotalDedupedSavings(), other.estimatedTotalDedupedSavings()) && Objects.equals(this.groupBy(), other.groupBy()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendationSummariesResponse").add("CurrencyCode", (Object)this.currencyCode()).add("EstimatedTotalDedupedSavings", (Object)this.estimatedTotalDedupedSavings()).add("GroupBy", (Object)this.groupBy()).add("Items", this.hasItems() ? this.items() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "estimatedTotalDedupedSavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedTotalDedupedSavings()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationSummariesResponse, T> g) {
        return obj -> g.apply((ListRecommendationSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostOptimizationHubResponse.BuilderImpl
    implements Builder {
        private String currencyCode;
        private Double estimatedTotalDedupedSavings;
        private String groupBy;
        private List<RecommendationSummary> items = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationSummariesResponse model) {
            super(model);
            this.currencyCode(model.currencyCode);
            this.estimatedTotalDedupedSavings(model.estimatedTotalDedupedSavings);
            this.groupBy(model.groupBy);
            this.items(model.items);
            this.nextToken(model.nextToken);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Double getEstimatedTotalDedupedSavings() {
            return this.estimatedTotalDedupedSavings;
        }

        public final void setEstimatedTotalDedupedSavings(Double estimatedTotalDedupedSavings) {
            this.estimatedTotalDedupedSavings = estimatedTotalDedupedSavings;
        }

        @Override
        public final Builder estimatedTotalDedupedSavings(Double estimatedTotalDedupedSavings) {
            this.estimatedTotalDedupedSavings = estimatedTotalDedupedSavings;
            return this;
        }

        public final String getGroupBy() {
            return this.groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final List<RecommendationSummary.Builder> getItems() {
            List<RecommendationSummary.Builder> result = RecommendationSummariesListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<RecommendationSummary.BuilderImpl> items) {
            this.items = RecommendationSummariesListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<RecommendationSummary> items) {
            this.items = RecommendationSummariesListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RecommendationSummary ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RecommendationSummary.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (RecommendationSummary)((RecommendationSummary.Builder)RecommendationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRecommendationSummariesResponse build() {
            return new ListRecommendationSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostOptimizationHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendationSummariesResponse> {
        public Builder currencyCode(String var1);

        public Builder estimatedTotalDedupedSavings(Double var1);

        public Builder groupBy(String var1);

        public Builder items(Collection<RecommendationSummary> var1);

        public Builder items(RecommendationSummary ... var1);

        public Builder items(Consumer<RecommendationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

