/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PaymentOption {
    NO_UPFRONT("NO_UPFRONT"),
    PARTIAL_UPFRONT("PARTIAL_UPFRONT"),
    ALL_UPFRONT("ALL_UPFRONT"),
    LIGHT_UTILIZATION("LIGHT_UTILIZATION"),
    MEDIUM_UTILIZATION("MEDIUM_UTILIZATION"),
    HEAVY_UTILIZATION("HEAVY_UTILIZATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PaymentOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PaymentOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PaymentOption.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PaymentOption> knownValues() {
        return Stream.of(PaymentOption.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

