/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.GenerationSummary;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationRequest;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationResponse;

public class ListSavingsPlansPurchaseRecommendationGenerationIterable
implements SdkIterable<ListSavingsPlansPurchaseRecommendationGenerationResponse> {
    private final CostExplorerClient client;
    private final ListSavingsPlansPurchaseRecommendationGenerationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSavingsPlansPurchaseRecommendationGenerationIterable(CostExplorerClient client, ListSavingsPlansPurchaseRecommendationGenerationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSavingsPlansPurchaseRecommendationGenerationResponseFetcher();
    }

    public Iterator<ListSavingsPlansPurchaseRecommendationGenerationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GenerationSummary> generationSummaryList() {
        Function<ListSavingsPlansPurchaseRecommendationGenerationResponse, Iterator> getIterator = response -> {
            if (response != null && response.generationSummaryList() != null) {
                return response.generationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSavingsPlansPurchaseRecommendationGenerationResponseFetcher
    implements SyncPageFetcher<ListSavingsPlansPurchaseRecommendationGenerationResponse> {
        private ListSavingsPlansPurchaseRecommendationGenerationResponseFetcher() {
        }

        public boolean hasNextPage(ListSavingsPlansPurchaseRecommendationGenerationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListSavingsPlansPurchaseRecommendationGenerationResponse nextPage(ListSavingsPlansPurchaseRecommendationGenerationResponse previousPage) {
            if (previousPage == null) {
                return ListSavingsPlansPurchaseRecommendationGenerationIterable.this.client.listSavingsPlansPurchaseRecommendationGeneration(ListSavingsPlansPurchaseRecommendationGenerationIterable.this.firstRequest);
            }
            return ListSavingsPlansPurchaseRecommendationGenerationIterable.this.client.listSavingsPlansPurchaseRecommendationGeneration((ListSavingsPlansPurchaseRecommendationGenerationRequest)((Object)ListSavingsPlansPurchaseRecommendationGenerationIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

